/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets.hyperlinkkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperlinkLCA
extends AbstractWidgetLCA {
    static final String PROP_TEXT = "text";
    static final String PROP_UNDERLINED = "underlined";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_ACTIVE_FOREGROUND = "activeForeground";
    static final String PROP_ACTIVE_BACKGROUND = "activeBackground";
    static final String PROP_INACTIVE_FOREGROUND = "inactiveForeground";
    static final String PROP_INACTIVE_BACKGROUND = "inactiveBackground";
    static final String PROP_UNDERLINE_MODE = "underlineMode";
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("click", "org.eclipse.ui.forms.widgets.Hyperlink.onClick", JSListenerType.ACTION);
    static /* synthetic */ Class class$0;

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    public void readData(Widget widget) {
        ControlLCAUtil.processSelection((Widget)widget, null, (boolean)false);
    }

    public void preserveValues(Widget widget) {
        Hyperlink hyperlink = (Hyperlink)widget;
        ControlLCAUtil.preserveValues((Control)hyperlink);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)hyperlink);
        adapter.preserve(PROP_TEXT, (Object)hyperlink.getText());
        adapter.preserve(PROP_UNDERLINED, (Object)hyperlink.isUnderlined());
        boolean hasListener = SelectionEvent.hasListener((Adaptable)hyperlink);
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)hasListener);
        adapter.preserve(PROP_ACTIVE_BACKGROUND, (Object)HyperlinkLCA.getActiveBackground(hyperlink));
        adapter.preserve(PROP_ACTIVE_FOREGROUND, (Object)HyperlinkLCA.getActiveForeground(hyperlink));
        adapter.preserve(PROP_UNDERLINE_MODE, (Object)HyperlinkLCA.getUnderlineMode(hyperlink));
    }

    public void renderInitialization(Widget widget) throws IOException {
        Hyperlink hyperlink = (Hyperlink)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
        writer.newWidget("org.eclipse.ui.forms.widgets.Hyperlink");
        WidgetLCAUtil.writeCustomVariant((Widget)widget);
    }

    public void renderChanges(Widget widget) throws IOException {
        Hyperlink hyperlink = (Hyperlink)widget;
        ControlLCAUtil.writeChanges((Control)hyperlink);
        HyperlinkLCA.writeText(hyperlink);
        HyperlinkLCA.writeSelectionListener(hyperlink);
        HyperlinkLCA.writeActiveForeground(hyperlink);
        HyperlinkLCA.writeActiveBackground(hyperlink);
        HyperlinkLCA.writeUnderlineMode(hyperlink);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)widget);
        writer.dispose();
    }

    private static void writeText(Hyperlink hyperlink) throws IOException {
        String text = hyperlink.getText();
        Boolean underlined = hyperlink.isUnderlined();
        Boolean def = Boolean.FALSE;
        boolean textChanged = WidgetLCAUtil.hasChanged((Widget)hyperlink, (String)PROP_TEXT, (Object)text, (Object)"");
        boolean underlinedChanged = WidgetLCAUtil.hasChanged((Widget)hyperlink, (String)PROP_UNDERLINED, (Object)underlined, (Object)def);
        if (textChanged || underlinedChanged) {
            text = WidgetLCAUtil.escapeText((String)text, (boolean)false);
            if (underlined.booleanValue()) {
                text = HyperlinkLCA.underlineText(text);
            }
            JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
            writer.set("label", text);
        }
    }

    private static void writeSelectionListener(Hyperlink hyperlink) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)hyperlink));
    }

    private static void writeActiveForeground(Hyperlink hyperlink) throws IOException {
        Color newValue = HyperlinkLCA.getActiveForeground(hyperlink);
        JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
        writer.set(PROP_ACTIVE_FOREGROUND, "activeTextColor", (Object)newValue, null);
    }

    private static void writeActiveBackground(Hyperlink hyperlink) throws IOException {
        Color newValue = HyperlinkLCA.getActiveBackground(hyperlink);
        JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
        writer.set(PROP_ACTIVE_BACKGROUND, "activeBackgroundColor", (Object)newValue, null);
    }

    private static void writeUnderlineMode(Hyperlink hyperlink) throws IOException {
        Integer newValue = HyperlinkLCA.getUnderlineMode(hyperlink);
        JSWriter writer = JSWriter.getWriterFor((Widget)hyperlink);
        writer.set(PROP_UNDERLINE_MODE, PROP_UNDERLINE_MODE, (Object)newValue, null);
    }

    private static String underlineText(String text) {
        StringBuffer result = new StringBuffer();
        result.append("<u>");
        result.append(text);
        result.append("</u>");
        return result.toString();
    }

    private static Color getActiveForeground(Hyperlink hyperlink) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = hyperlink.getAdapter(clazz);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        Color newValue = hyperlinkAdapter.getActiveForeground();
        return newValue;
    }

    private static Color getActiveBackground(Hyperlink hyperlink) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = hyperlink.getAdapter(clazz);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        Color newValue = hyperlinkAdapter.getActiveBackground();
        return newValue;
    }

    private static Integer getUnderlineMode(Hyperlink hyperlink) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = hyperlink.getAdapter(clazz);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        Integer newValue = new Integer(hyperlinkAdapter.getUnderlineMode());
        return newValue;
    }
}

