/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.internal.forms.widgets.FormImages;

public class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Control descriptionControl;
    private Control separator;
    private Hashtable titleColors;
    private static final String COLOR_BG = "bg";
    private static final String COLOR_GBG = "gbg";
    private static final String COLOR_BORDER = "border";

    public Section(Composite parent, int style) {
        this(parent, 0, style);
    }

    Section(Composite parent, int cstyle, int style) {
        super(parent, cstyle | Section.getBackgroundStyle(style), style);
        int rtl = cstyle;
        if ((style & 0x80) != 0) {
            this.descriptionControl = new Text((Composite)this, 0x48 | rtl);
        }
        if ((style & 0x100) != 0) {
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    Image image = Section.super.getBackgroundImage();
                    if (image != null) {
                        FormImages.getInstance().markFinished(image);
                    }
                    Section.super.setBackgroundImage(null);
                }
            };
            this.addListener(12, listener);
            this.addListener(11, listener);
        }
    }

    private static int getBackgroundStyle(int estyle) {
        return 0;
    }

    protected void internalSetExpanded(boolean expanded) {
        super.internalSetExpanded(expanded);
        if ((this.getExpansionStyle() & 0x100) != 0 && !expanded) {
            super.setBackgroundImage(null);
        }
        this.reflow();
    }

    protected void reflow() {
        Section c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)((Object)c)).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite) break;
        }
    }

    public void setDescription(String description) {
        if (this.descriptionControl instanceof Text) {
            ((Text)this.descriptionControl).setText(description);
        }
    }

    public String getDescription() {
        if (this.descriptionControl instanceof Text) {
            return ((Text)this.descriptionControl).getText();
        }
        return null;
    }

    public void setSeparatorControl(Control separator) {
        Assert.isTrue((separator != null && separator.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = separator;
    }

    public Control getSeparatorControl() {
        return this.separator;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setForeground(fg);
        }
    }

    public Control getDescriptionControl() {
        return this.descriptionControl;
    }

    public void setDescriptionControl(Control descriptionControl) {
        Assert.isTrue(((this.getExpansionStyle() & 0x80) == 0 ? 1 : 0) != 0);
        Assert.isTrue((descriptionControl != null && descriptionControl.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.descriptionControl = descriptionControl;
    }

    public void setTitleBarBorderColor(Color color) {
        this.putTitleBarColor(COLOR_BORDER, color);
    }

    public void setTitleBarBackground(Color color) {
        this.putTitleBarColor(COLOR_BG, color);
    }

    public void setTitleBarGradientBackground(Color color) {
        this.putTitleBarColor(COLOR_GBG, color);
    }

    public Color getTitleBarBorderColor() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BORDER);
    }

    public Color getTitleBarGradientBackground() {
        if (this.titleColors == null) {
            return null;
        }
        if ((this.getExpansionStyle() & 0x200) != 0) {
            return this.getBackground();
        }
        return (Color)this.titleColors.get(COLOR_GBG);
    }

    public Color getTitleBarBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BG);
    }

    private void putTitleBarColor(String key, Color color) {
        if (color == null) {
            return;
        }
        if (this.titleColors == null) {
            this.titleColors = new Hashtable();
        }
        this.titleColors.put(key, color);
    }

    public final void setBackgroundImage(Image image) {
    }
}

