/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FormImages {
    private static FormImages instance;
    private HashMap images;
    private HashMap ids;

    public static FormImages getInstance() {
        if (instance == null) {
            instance = new FormImages();
        }
        return instance;
    }

    private FormImages() {
    }

    public boolean markFinished(Image image) {
        ImageReference ref;
        this.checkHashMaps();
        ImageIdentifier id = (ImageIdentifier)this.ids.get(image);
        if (id != null && (ref = (ImageReference)this.images.get(id)) != null) {
            if (ref.decCount()) {
                this.images.remove(id);
                this.ids.remove(ref.getImage());
                this.validateHashMaps();
            }
            return true;
        }
        return false;
    }

    private void checkHashMaps() {
        if (this.images == null) {
            this.images = new HashMap();
        }
        if (this.ids == null) {
            this.ids = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.images.size() == 0) {
            this.images = null;
        }
        if (this.ids.size() == 0) {
            this.ids = null;
        }
    }

    private abstract class ImageIdentifier {
        Display fDisplay;
        Color[] fColors;
        int fLength;

        ImageIdentifier(Display display, Color[] colors, int length) {
            this.fDisplay = display;
            this.fColors = colors;
            this.fLength = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImageIdentifier) {
                ImageIdentifier id = (ImageIdentifier)obj;
                if (id.fColors.length == this.fColors.length) {
                    boolean result = id.fDisplay.equals(this.fDisplay) && id.fLength == this.fLength;
                    int i = 0;
                    while (i < this.fColors.length && result) {
                        result = result && id.fColors[i].equals((Object)this.fColors[i]);
                        ++i;
                    }
                    return result;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = this.fDisplay.hashCode();
            int i = 0;
            while (i < this.fColors.length) {
                hash = hash * 7 + this.fColors[i].hashCode();
                ++i;
            }
            hash = hash * 7 + this.fLength;
            return hash;
        }
    }

    private class ImageReference {
        private Image fImage;
        private int fCount;

        public ImageReference(Image image) {
            this.fImage = image;
            this.fCount = 1;
        }

        public Image getImage() {
            return this.fImage;
        }

        public boolean decCount() {
            return --this.fCount == 0;
        }

        public void incCount() {
            ++this.fCount;
        }
    }
}

