/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.tab.SelectionDialogUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

final class EntryPointSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = "org.eclipse.rap.ui.launch.ENTRY_POINT_SELECTION_DIALOG";
    private static final Comparator COMPARATOR = new EntryPointComparator();
    private EntryPointExtension[] entryPoints;

    EntryPointSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(LaunchMessages.EntryPointSelectionDialog_Title);
        String msg = LaunchMessages.EntryPointSelectionDialog_Message;
        this.setMessage(msg);
        this.setSelectionHistory(new EntryPointSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new EntryPointLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new EntryPointLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        if (this.entryPoints == null) {
            if (monitor != null) {
                String msg = LaunchMessages.EntryPointSelectionDialog_Searching;
                monitor.beginTask(msg, -1);
            }
            this.entryPoints = EntryPointExtension.findInWorkspace(monitor);
        }
        int i = 0;
        while (i < this.entryPoints.length) {
            provider.add((Object)this.entryPoints[i], itemsFilter);
            ++i;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        SearchPattern searchPattern = SelectionDialogUtil.createSearchPattern();
        return new EntryPointItemsFilter(searchPattern);
    }

    public String getElementName(Object element) {
        EntryPointExtension entryPoint = (EntryPointExtension)element;
        String project = entryPoint.getProject();
        String parameter = entryPoint.getParameter();
        return SelectionDialogUtil.getLabel(project, parameter);
    }

    protected Comparator getItemsComparator() {
        return COMPARATOR;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    private static final class EntryPointComparator
    implements Comparator {
        private EntryPointComparator() {
        }

        public int compare(Object object1, Object object2) {
            EntryPointExtension extension1 = (EntryPointExtension)object1;
            EntryPointExtension extension2 = (EntryPointExtension)object2;
            String string1 = String.valueOf(extension1.getProject()) + extension1.getParameter();
            String string2 = String.valueOf(extension2.getProject()) + extension2.getParameter();
            return string1.compareTo(string2);
        }
    }

    private final class EntryPointItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public EntryPointItemsFilter(SearchPattern searchPattern) {
            super((FilteredItemsSelectionDialog)EntryPointSelectionDialog.this, searchPattern);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            return this.matches(((EntryPointExtension)item).getParameter());
        }
    }

    private static final class EntryPointLabelProvider
    extends LabelProvider {
        private final Image image = Images.EXTENSION.createImage();

        private EntryPointLabelProvider() {
        }

        public String getText(Object element) {
            String result = null;
            if (element != null) {
                EntryPointExtension entryPoint = (EntryPointExtension)element;
                String project = entryPoint.getProject();
                String parameter = entryPoint.getParameter();
                result = SelectionDialogUtil.getLabel(project, parameter);
            }
            return result;
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public void dispose() {
            this.image.dispose();
            super.dispose();
        }
    }

    private static final class EntryPointSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private EntryPointSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

