/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.ui.internal.servlet.EntryPointExtension;
import org.eclipse.rap.ui.internal.servlet.ResourceManagerFactory;
import org.eclipse.rwt.internal.AdapterFactoryRegistry;
import org.eclipse.rwt.internal.EngineConfig;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandlerConfigurer;
import org.eclipse.rwt.internal.service.ServiceManager;
import org.eclipse.rwt.internal.service.SettingStoreManager;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManagerFactory;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.WorkbenchFileSettingStoreFactory;
import org.osgi.framework.Bundle;

final class EngineConfigWrapper
implements IEngineConfig {
    private static final String FOLDER;
    private static final String CONFIG;
    private static final String ID_ADAPTER_FACTORY = "org.eclipse.rap.ui.adapterfactory";
    private static final String ID_ENTRY_POINT = "org.eclipse.rap.ui.entrypoint";
    private static final String ID_THEMES = "org.eclipse.rap.ui.themes";
    private static final String ID_THEMEABLE_WIDGETS = "org.eclipse.rap.ui.themeableWidgets";
    private static final String ID_PHASE_LISTENER = "org.eclipse.rap.ui.phaselistener";
    private static final String ID_RESOURCES = "org.eclipse.rap.ui.resources";
    private static final String ID_SETTING_STORES = "org.eclipse.rap.ui.settingstores";
    private final EngineConfig engineConfig = new EngineConfig(EngineConfigWrapper.findContextPath().toString());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rap.ui.internal.servlet.EngineConfigWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FOLDER = clazz.getPackage().getName().replace('.', '/');
        CONFIG = String.valueOf(FOLDER) + "/config.xml";
    }

    EngineConfigWrapper() {
        EngineConfigWrapper.registerPhaseListener();
        EngineConfigWrapper.registerRWTLifeCycle();
        EngineConfigWrapper.registerResourceManagerFactory();
        EngineConfigWrapper.registerSettingStoreFactory();
        EngineConfigWrapper.registerWorkbenchEntryPoint();
        EngineConfigWrapper.registerThemeableWidgets();
        EngineConfigWrapper.registerThemes();
        EngineConfigWrapper.registerFactories();
        EngineConfigWrapper.registerResources();
        this.registerLifeCycleServiceHandlerConfigurer();
        EngineConfigWrapper.registerUICallBackServiceHandler();
        this.registerJSLibraryServiceHandler();
    }

    public File getClassDir() {
        return this.engineConfig.getClassDir();
    }

    public File getConfigFile() {
        File result = this.engineConfig.getConfigFile();
        if (!result.exists()) {
            result.getParentFile().mkdirs();
            try {
                result.createNewFile();
                EngineConfigWrapper.createConfiguration(result);
            }
            catch (IOException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
        }
        return result;
    }

    public File getLibDir() {
        return this.engineConfig.getLibDir();
    }

    public File getServerContextDir() {
        return this.engineConfig.getServerContextDir();
    }

    public File getSourceDir() {
        return this.engineConfig.getSourceDir();
    }

    private static void registerPhaseListener() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_PHASE_LISTENER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                PhaseListener listener = (PhaseListener)elements[i].createExecutableExtension("class");
                PhaseListenerRegistry.add((PhaseListener)listener);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private static void registerResourceManagerFactory() {
        ResourceManager.register((IResourceManagerFactory)new ResourceManagerFactory());
    }

    private static void registerSettingStoreFactory() {
        WorkbenchFileSettingStoreFactory result = null;
        String factoryId = System.getProperty("org.eclipse.rwt.settingStoreFactory");
        if (factoryId != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(ID_SETTING_STORES);
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (factoryId.equals(id)) {
                    try {
                        Object obj = elements[i].createExecutableExtension("class");
                        if (obj instanceof ISettingStoreFactory) {
                            result = (ISettingStoreFactory)obj;
                        }
                    }
                    catch (CoreException cex) {
                        WorkbenchPlugin.log(cex.getStatus());
                    }
                }
                ++i;
            }
            if (result == null) {
                String msg = "Warning: could not find the factory with id '" + factoryId + "' in org.eclipse.rap.ui.settingstores";
                WorkbenchPlugin.log(WorkbenchPlugin.getStatus(new Throwable(msg)));
            }
        }
        if (result == null) {
            result = new WorkbenchFileSettingStoreFactory();
        }
        SettingStoreManager.register(result);
    }

    private static void registerFactories() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_ADAPTER_FACTORY);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String factoryName = elements[i].getAttribute("factoryClass");
            String adaptableName = elements[i].getAttribute("adaptableClass");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class factoryClass = bundle.loadClass(factoryName);
                Class adaptableClass = bundle.loadClass(adaptableName);
                AdapterFactoryRegistry.add((Class)factoryClass, (Class)adaptableClass);
            }
            catch (Throwable thr) {
                String text = "Could not register adapter factory ''{0}'' for the adapter type ''{1}''.";
                Object[] param = new Object[]{factoryName, adaptableName};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, thr);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    private static void registerWorkbenchEntryPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_ENTRY_POINT);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String className = elements[i].getAttribute("class");
            String parameter = elements[i].getAttribute("parameter");
            String id = elements[i].getAttribute("id");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class clazz = bundle.loadClass(className);
                EntryPointManager.register((String)parameter, (Class)clazz);
                EntryPointExtension.bind(id, parameter);
            }
            catch (Throwable thr) {
                String text = "Could not register entry point ''{0}'' with request startup parameter ''{1}''.";
                Object[] param = new Object[]{className, parameter};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, thr);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    private static void registerThemeableWidgets() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMEABLE_WIDGETS);
        IConfigurationElement[] widgetExts = ep.getConfigurationElements();
        int i = 0;
        while (i < widgetExts.length) {
            String contributorName = widgetExts[i].getContributor().getName();
            String widgetClass = widgetExts[i].getAttribute("class");
            try {
                final Bundle bundle = Platform.getBundle((String)contributorName);
                ResourceLoader resLoader = new ResourceLoader(){

                    public InputStream getResourceAsStream(String resourceName) throws IOException {
                        InputStream result = null;
                        URL url = bundle.getResource(resourceName);
                        if (url != null) {
                            result = url.openStream();
                        }
                        return result;
                    }
                };
                Class widget = bundle.loadClass(widgetClass);
                ThemeManager.getInstance().addThemeableWidget(widget, resLoader);
            }
            catch (Throwable e) {
                String text = "Could not register themeable widget ''{0}''.";
                Object[] param = new Object[]{widgetClass};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, e);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                String reason = e instanceof ClassNotFoundException ? "Class not found" : e.getMessage();
                System.err.println("ERROR: " + msg + " Reason: " + reason);
            }
            ++i;
        }
    }

    private static void registerThemes() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        ThemeManager.getInstance().initialize();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String themeId = elements[i].getAttribute("id");
            String themeFile = elements[i].getAttribute("file");
            String themeName = elements[i].getAttribute("name");
            try {
                final Bundle bundle = Platform.getBundle((String)contributorName);
                ResourceLoader resLoader = new ResourceLoader(){

                    public InputStream getResourceAsStream(String resourceName) throws IOException {
                        Path file = new Path(resourceName);
                        return FileLocator.openStream((Bundle)bundle, (IPath)file, (boolean)false);
                    }
                };
                ThemeManager.getInstance().registerTheme(themeId, themeName, themeFile, resLoader);
            }
            catch (Exception e) {
                String text = "Could not register custom theme ''{0}'' from file ''{1}''.";
                Object[] param = new Object[]{themeId, themeFile};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, (Throwable)e);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                System.err.println("ERROR: " + msg + " Reason: " + e.getMessage());
            }
            ++i;
        }
    }

    private static void registerRWTLifeCycle() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.LifeCycleFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Field field = clazz2.getDeclaredField("globalLifeCycle");
            field.setAccessible(true);
            field.set(null, new RWTLifeCycle());
        }
        catch (Throwable shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private static IPath findContextPath() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        return stateLocation.append("context");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createConfiguration(File destination) throws FileNotFoundException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rap.ui.internal.servlet.EngineConfigWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        ClassLoader loader = clazz.getClassLoader();
        InputStream is = loader.getResourceAsStream(CONFIG);
        try {
            FileOutputStream out = new FileOutputStream(destination);
            try {
                int character = is.read();
                while (character != -1) {
                    ((OutputStream)out).write(character);
                    character = is.read();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                ((OutputStream)out).close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            is.close();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        is.close();
    }

    private void registerLifeCycleServiceHandlerConfigurer() {
        LifeCycleServiceHandler.configurer = new LifeCycleServiceHandlerConfigurer();
    }

    private static void registerResources() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_RESOURCES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                IResource resource = (IResource)elements[i].createExecutableExtension("class");
                ResourceRegistry.add((IResource)resource);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private static void registerUICallBackServiceHandler() {
        ServiceManager.registerServiceHandler((String)UICallBackServiceHandler.HANDLER_ID, (IServiceHandler)new UICallBackServiceHandler());
    }

    private void registerJSLibraryServiceHandler() {
        ServiceManager.registerServiceHandler((String)JSLibraryServiceHandler.HANDLER_ID, (IServiceHandler)new JSLibraryServiceHandler());
    }
}

