/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.eclipse.rap.ui.internal.servlet.RequestHandler;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    public static final String DEFAULT_SERVLET = "rap";
    public static final String ID_HTTP_CONTEXT = "org.eclipse.rap.httpcontext";
    private HttpService httpService;
    private final List servletAliases;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HttpServiceTracker(BundleContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz.getName(), null);
        this.servletAliases = new ArrayList();
    }

    public Object addingService(ServiceReference reference) {
        this.httpService = (HttpService)this.context.getService(reference);
        HttpContext rapContext = this.getRAPHttpContext(reference);
        if (this.servletAliases.size() == 0) {
            this.servletAliases.add(DEFAULT_SERVLET);
        }
        Iterator it = this.servletAliases.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                RequestHandler handler = new RequestHandler();
                this.httpService.registerServlet("/" + name, (Servlet)handler, null, rapContext);
            }
            catch (Exception e) {
                String text = "Could not register servlet mapping ''{0}''.";
                Object[] param = new Object[]{name};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, "org.eclipse.rap.ui", 0, msg, (Throwable)e);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return this.httpService;
    }

    private HttpContext getRAPHttpContext(ServiceReference reference) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.http.registry.HttpContextExtensionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = clazz.getName();
        ServiceReference serviceRef = this.context.getServiceReference(name);
        HttpContextExtensionService service = (HttpContextExtensionService)this.context.getService(serviceRef);
        return service.getHttpContext(reference, ID_HTTP_CONTEXT);
    }

    public void removedService(ServiceReference reference, Object service) {
        Iterator iterator = this.servletAliases.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            this.httpService.unregister("/" + name);
        }
        super.removedService(reference, service);
    }

    public void addServletAlias(String name) {
        this.servletAliases.add(name);
    }
}

