/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.BaseSaveAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SaveAsAction
extends BaseSaveAction {
    public SaveAsAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.get().SaveAs_text, window);
        this.setActionDefinitionId("org.eclipse.ui.file.saveAs");
        this.setText(WorkbenchMessages.get().SaveAs_text);
        this.setToolTipText(WorkbenchMessages.get().SaveAs_toolTip);
        this.setId("saveAs");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT_DISABLED"));
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            saveView.doSaveAs();
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSaveAs();
        }
    }

    protected void updateState() {
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            this.setEnabled(saveView.isSaveAsAllowed());
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        this.setEnabled(editor != null && editor.isSaveAsAllowed());
    }
}

