/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class DefaultDetailsArea
extends AbstractStatusAreaProvider {
    private WorkbenchStatusDialogManager workbenchStatusDialog;
    protected static final int MASK = 15;
    private static final Object NESTING_INDENT = "  ";
    private List list;

    public DefaultDetailsArea(WorkbenchStatusDialogManager wsd) {
        this.workbenchStatusDialog = wsd;
    }

    public Control createSupportArea(Composite parent, StatusAdapter statusAdapter) {
        Composite area = this.createArea(parent);
        this.setStatusAdapter(statusAdapter);
        return area;
    }

    protected Composite createArea(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout pggl = new GridLayout();
        parent.setLayout((Layout)pggl);
        GridData pgd = new GridData(768);
        pgd.grabExcessHorizontalSpace = true;
        parent.setLayoutData((Object)pgd);
        this.list = new List(parent, 2818);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 250;
        gd.heightHint = 100;
        this.list.setLayoutData((Object)gd);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDetailsArea.this.list.selectAll();
                super.widgetSelected(e);
            }
        });
        this.createDNDSource();
        this.createCopyAction(parent);
        return parent;
    }

    protected void setStatusAdapter(StatusAdapter adapter) {
        Long timestamp;
        this.list.removeAll();
        this.populateList(this.list, adapter.getStatus(), 0);
        if (this.workbenchStatusDialog.getStatusAdapters().size() == 1 && (timestamp = (Long)adapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY)) != null) {
            String date = DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(timestamp));
            this.list.add(NLS.bind((String)ProgressMessages.get().JobInfo_Error, (Object[])new Object[]{"", date}));
        }
    }

    private void createDNDSource() {
    }

    private void createCopyAction(Composite parent) {
    }

    private void populateList(List list, IStatus status, int nesting) {
        if (!status.matches(15)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(status.getMessage());
        list.add(buffer.toString());
        Throwable t = status.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateList(list, ce.getStatus(), nesting + 1);
        } else if (t != null) {
            buffer = new StringBuffer();
            int i2 = 0;
            while (i2 < nesting) {
                buffer.append(NESTING_INDENT);
                ++i2;
            }
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            buffer.append(message);
            list.add(buffer.toString());
        }
        IStatus[] children = status.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            this.populateList(list, children[i3], nesting + 1);
            ++i3;
        }
    }

    public List getList() {
        return this.list;
    }
}

