/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.rap.ui.interactiondesign.layout.model.ILayoutSetInitializer;
import org.eclipse.rap.ui.interactiondesign.layout.model.Layout;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.ui.internal.util.PrefUtil;

public class LayoutRegistry {
    private static LayoutRegistry registry;
    private String layoutId = "org.eclipse.rap.ui.defaultlayout";
    private Map layoutMap = new HashMap();
    private Layout activeLayout;
    private List builders = new ArrayList();
    private Map layoutSetToPluginId = new HashMap();
    public static final String DEFAULT_LAYOUT_ID = "org.eclipse.rap.ui.defaultlayout";
    private static final String LAYOUT_EXT_ID = "org.eclipse.rap.ui.layouts";
    public static final String SAVED_LAYOUT_KEY = "org.eclipse.rap.ui.layouts.saved";

    public static LayoutRegistry getInstance() {
        if (registry == null) {
            registry = new LayoutRegistry();
        }
        return registry;
    }

    private LayoutRegistry() {
        this.init();
    }

    private void combineLayoutSets(Layout layout, Layout defaultLayout, Layout activeLayout) {
        if (defaultLayout != null) {
            Map defaultLayoutSets = defaultLayout.getLayoutSets();
            this.createLayoutSetFromLayout(layout, defaultLayoutSets);
        }
        Map activeLayoutSets = activeLayout.getLayoutSets();
        this.createLayoutSetFromLayout(layout, activeLayoutSets);
    }

    private Layout createHybridLayout() {
        Layout result = new Layout(this.layoutId);
        Layout defaultLayout = (Layout)this.layoutMap.get(DEFAULT_LAYOUT_ID);
        this.combineLayoutSets(result, defaultLayout, this.activeLayout);
        return result;
    }

    private void createLayoutSetFromLayout(Layout layout, Map layoutSets) {
        Object[] keys = layoutSets.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            LayoutSet set = (LayoutSet)layoutSets.get(key);
            layout.clearLayoutSet(key);
            layout.addLayoutSet(set);
            ++i;
        }
    }

    String getPluginIdForLayoutSet(String layoutSetId) {
        return (String)this.layoutSetToPluginId.get(layoutSetId);
    }

    private void createLayoutSets(IConfigurationElement[] layoutSets, Layout layout) {
        if (layoutSets != null && layoutSets.length > 0) {
            int i = 0;
            while (i < layoutSets.length) {
                IConfigurationElement layoutSetElement = layoutSets[i];
                String pluginId = layoutSetElement.getContributor().getName();
                String layoutSetId = layoutSetElement.getAttribute("id");
                layout.clearLayoutSet(layoutSetId);
                LayoutSet layoutSet = layout.getLayoutSet(layoutSetId);
                this.layoutSetToPluginId.put(layoutSetId, pluginId);
                try {
                    Object initializer = layoutSetElement.createExecutableExtension("class");
                    if (initializer instanceof ILayoutSetInitializer) {
                        ILayoutSetInitializer layoutInitializer = (ILayoutSetInitializer)initializer;
                        layoutInitializer.initializeLayoutSet(layoutSet);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void disposeBuilders() {
        int i = 0;
        while (i < this.builders.size()) {
            ElementBuilder builder = (ElementBuilder)this.builders.get(i);
            builder.dispose();
            ++i;
        }
    }

    public Layout getActiveLayout() {
        Layout result = this.activeLayout;
        if (this.layoutId.equals(DEFAULT_LAYOUT_ID)) {
            if (result == null) {
                this.activeLayout = result = (Layout)this.layoutMap.get(this.layoutId);
            }
        } else {
            result = this.createHybridLayout();
        }
        return result;
    }

    public IConfigurationElement[] getLayoutExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] result = registry.getConfigurationElementsFor(LAYOUT_EXT_ID);
        return result;
    }

    public String getSavedLayoutId() {
        String result = "";
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        result = preferenceStore.getString(SAVED_LAYOUT_KEY);
        return result;
    }

    public void init() {
        IConfigurationElement[] elements = this.getLayoutExtensions();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            Layout layout = (Layout)this.layoutMap.get(id);
            IConfigurationElement[] layoutSets = elements[i].getChildren("layoutSet");
            if (layout == null) {
                layout = this.initLayout(layoutSets, id);
                this.layoutMap.put(id, layout);
            } else {
                this.createLayoutSets(layoutSets, layout);
            }
            ++i;
        }
    }

    private Layout initLayout(IConfigurationElement[] configurationElements, String id) {
        Layout result = (Layout)this.layoutMap.get(id);
        if (result == null) {
            result = new Layout(id);
        }
        this.createLayoutSets(configurationElements, result);
        return result;
    }

    public void notifyLayoutChanged() {
        this.disposeBuilders();
    }

    void registerBuilder(ElementBuilder builder) {
        this.builders.add(builder);
    }

    public void saveLayoutId(String id) {
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        preferenceStore.putValue(SAVED_LAYOUT_KEY, id);
        preferenceStore.firePropertyChangeEvent(SAVED_LAYOUT_KEY, (Object)"", (Object)id);
    }

    public void setActiveLayout(String id, boolean save) {
        Object object = this.layoutMap.get(id);
        Layout newActive = (Layout)object;
        if (newActive != null) {
            this.layoutId = id;
            this.activeLayout = newActive;
            if (save) {
                this.saveLayoutId(this.layoutId);
            }
        }
    }
}

