/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;

public class ActivePartSourceProvider
extends AbstractSourceProvider {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeEditorId", "activeEditor", "activePartId", "activePart", "activeSite", "showInSelection", "showInInput"};
    private IEditorPart lastActiveEditor = null;
    private String lastActiveEditorId = null;
    private IWorkbenchPart lastActivePart = null;
    private String lastActivePartId = null;
    private IWorkbenchPartSite lastActivePartSite = null;
    private Object lastShowInInput = null;
    private ISelection lastShowInSelection = null;
    private final IPartListener partListener = new IPartListener(){

        public final void partActivated(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partBroughtToTop(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partClosed(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partDeactivated(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partOpened(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public final void windowActivated(IWorkbenchWindow window) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowClosed(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().removePartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowDeactivated(IWorkbenchWindow window) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowOpened(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().addPartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }
    };
    private IWorkbench workbench;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public final void checkActivePart() {
        Object newActiveEditorId;
        Object newActiveEditor;
        Object newShowInSelection;
        Object newShowInInput;
        Object newActivePartSite;
        Object newActivePartId;
        Map currentState = this.getCurrentState();
        int sources = 0;
        Object newActivePart = currentState.get("activePart");
        if (!Util.equals(newActivePart, this.lastActivePart)) {
            sources |= 0x100000;
            this.lastActivePart = (IWorkbenchPart)newActivePart;
        }
        if (!Util.equals(newActivePartId = currentState.get("activePartId"), this.lastActivePartId)) {
            sources |= 0x400000;
            this.lastActivePartId = (String)newActivePartId;
        }
        if (!Util.equals(newActivePartSite = currentState.get("activeSite"), this.lastActivePartSite)) {
            sources |= 0x4000000;
            this.lastActivePartSite = (IWorkbenchPartSite)newActivePartSite;
        }
        if (!Util.equals(newShowInInput = currentState.get("showInInput"), this.lastShowInInput)) {
            sources |= 0x4000000;
            this.lastShowInInput = newShowInInput;
        }
        if (!Util.equals(newShowInSelection = currentState.get("showInSelection"), this.lastShowInSelection)) {
            sources |= 0x4000000;
            this.lastShowInSelection = (ISelection)newShowInSelection;
        }
        if (!Util.equals(newActiveEditor = currentState.get("activeEditor"), this.lastActiveEditor)) {
            sources |= 0x10000;
            this.lastActiveEditor = (IEditorPart)newActiveEditor;
        }
        if (!Util.equals(newActiveEditorId = currentState.get("activeEditorId"), this.lastActiveEditorId)) {
            sources |= 0x40000;
            this.lastActiveEditorId = (String)newActiveEditorId;
        }
        if (sources != 0) {
            if (DEBUG) {
                if ((sources & 0x100000) != 0) {
                    this.logDebuggingInfo("Active part changed to " + this.lastActivePart);
                }
                if ((sources & 0x400000) != 0) {
                    this.logDebuggingInfo("Active part id changed to " + this.lastActivePartId);
                }
                if ((sources & 0x4000000) != 0) {
                    this.logDebuggingInfo("Active site changed to " + this.lastActivePartSite);
                }
                if ((sources & 0x10000) != 0) {
                    this.logDebuggingInfo("Active editor changed to " + this.lastActiveEditor);
                }
                if ((sources & 0x40000) != 0) {
                    this.logDebuggingInfo("Active editor id changed to " + this.lastActiveEditorId);
                }
            }
            this.fireSourceChanged(sources, currentState);
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IShowInSource)Util.getAdapter(sourcePart, clazz);
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    public final void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
    }

    public final Map getCurrentState() {
        IWorkbenchPage activeWorkbenchPage;
        HashMap<String, Object> currentState = new HashMap<String, Object>(7);
        currentState.put("activeSite", null);
        currentState.put("activePart", null);
        currentState.put("activePartId", null);
        currentState.put("activeEditor", null);
        currentState.put("activeEditorId", null);
        currentState.put("showInInput", null);
        currentState.put("showInSelection", null);
        IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activeWorkbenchPage = activeWorkbenchWindow.getActivePage()) != null) {
            IEditorSite activeEditorSite;
            IWorkbenchPart newActivePart = activeWorkbenchPage.getActivePart();
            currentState.put("activePart", newActivePart);
            if (newActivePart != null) {
                ShowInContext context;
                IWorkbenchPartSite activeWorkbenchPartSite = newActivePart.getSite();
                currentState.put("activeSite", activeWorkbenchPartSite);
                if (activeWorkbenchPartSite != null) {
                    String newActivePartId = activeWorkbenchPartSite.getId();
                    currentState.put("activePartId", newActivePartId);
                }
                if ((context = this.getContext(newActivePart)) != null) {
                    currentState.put("showInInput", context.getInput());
                    currentState.put("showInSelection", context.getSelection());
                }
            }
            IEditorPart newActiveEditor = activeWorkbenchPage.getActiveEditor();
            currentState.put("activeEditor", newActiveEditor);
            if (newActiveEditor != null && (activeEditorSite = newActiveEditor.getEditorSite()) != null) {
                String newActiveEditorId = activeEditorSite.getId();
                currentState.put("activeEditorId", newActiveEditorId);
            }
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public void initialize(IServiceLocator locator) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IWorkbench");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.workbench = (IWorkbench)locator.getService(clazz);
        this.workbench.addWindowListener(this.windowListener);
    }
}

