/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ResourceTranslatorHelper {
    private static final Class[] PARAM_TYPE_ALGORITHM;
    private static final String METHOD_SET_TRANSLATOR_ALGORITHM = "setTranslatorAlgorithm";
    private static final String METHOD_GET_BUNDLE_CONTEXT = "getBundleContext";
    private static final String FIELD_ALGORITHM_IO = "algorithmIO";
    private static Class CLASS_REGISTRY_FACTORY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Runnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        PARAM_TYPE_ALGORITHM = classArray;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.runtime.RegistryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_REGISTRY_FACTORY = clazz2;
    }

    static void registerAlgorithm() {
        if (ResourceTranslatorHelper.isRWTLocalSpecificTranslationAllowed()) {
            try {
                Object[] param = new Object[]{new TranslatorAlgorithm()};
                ResourceTranslatorHelper.getAlgorithmSetter().invoke(null, param);
            }
            catch (Exception shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
        }
    }

    private static boolean isRWTLocalSpecificTranslationAllowed() {
        boolean result = false;
        try {
            ResourceTranslatorHelper.getAlgorithmIO();
            ResourceTranslatorHelper.getAlgorithmSetter();
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private static Method getAlgorithmSetter() throws NoSuchMethodException {
        String name = METHOD_SET_TRANSLATOR_ALGORITHM;
        Class[] type = PARAM_TYPE_ALGORITHM;
        return CLASS_REGISTRY_FACTORY.getDeclaredMethod(name, type);
    }

    private static Field getAlgorithmIO() throws NoSuchFieldException {
        return CLASS_REGISTRY_FACTORY.getDeclaredField(FIELD_ALGORITHM_IO);
    }

    private ResourceTranslatorHelper() {
    }

    private static final class TranslatorAlgorithm
    implements Runnable {
        private TranslatorAlgorithm() {
        }

        public void run() {
            String result = this.getKey();
            ResourceBundle bundle = null;
            try {
                if (ContextProvider.hasContext()) {
                    bundle = this.getResourceBundle();
                }
            }
            catch (Exception shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
            if (bundle != null) {
                result = ResourceTranslator.getResourceString(null, (String)this.getKey(), (ResourceBundle)bundle);
            }
            this.getIOHandle().set(result);
        }

        private ResourceBundle getResourceBundle() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Bundle bundle = Platform.getBundle((String)this.getSymbolicName());
            BundleContext bundleContext = this.getBundleContext(bundle);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.localization.BundleLocalization");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String id = clazz.getName();
            ServiceReference reference = bundleContext.getServiceReference(id);
            BundleLocalization localization = (BundleLocalization)bundleContext.getService(reference);
            return localization.getLocalization(bundle, RWT.getLocale().toString());
        }

        private BundleContext getBundleContext(Bundle bundle) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.osgi.framework.Bundle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method getBundleContext = clazz.getDeclaredMethod(ResourceTranslatorHelper.METHOD_GET_BUNDLE_CONTEXT, null);
            return (BundleContext)getBundleContext.invoke((Object)bundle, null);
        }

        private String getKey() {
            return ((String[])this.getIOHandle().get())[0];
        }

        private String getSymbolicName() {
            return ((String[])this.getIOHandle().get())[1];
        }

        private ThreadLocal getIOHandle() {
            ThreadLocal io = null;
            try {
                io = (ThreadLocal)ResourceTranslatorHelper.getAlgorithmIO().get(null);
            }
            catch (Exception shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
            return io;
        }
    }
}

