/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver;

import java.util.Collection;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyExtractorsRegistry {
    private Collection<PolicyExtractor> extractors;

    public PolicyExtractor getExtractor(Class<? extends PolicyDefinitionDescription> definitionDescriptorType, Class<?> platformPolicyType) {
        if (this.extractors == null) {
            throw new SwordfishException("Couldn't find matching policy extractor, extractors registry is not initialized properly. ");
        }
        for (PolicyExtractor x : this.extractors) {
            if (!x.isSupportedType(definitionDescriptorType) || x.getPlatformPolicyType() != platformPolicyType) continue;
            return x;
        }
        return null;
    }

    public Collection<PolicyExtractor> getExtractors() {
        return this.extractors;
    }

    public void setExtractors(Collection<PolicyExtractor> extractors) {
        this.extractors = extractors;
    }

    public boolean isEmpty() {
        return this.extractors == null || this.extractors.isEmpty();
    }
}

