/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.smx;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.jbi.runtime.impl.NormalizedMessageImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ExchangeImpl;
import org.apache.servicemix.nmr.core.MessageImpl;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.marshalers.JBIMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.eclipse.swordfish.internal.core.util.smx.MockSoapHelper;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SimpleClient
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(SimpleClient.class);
    private String dataToSend;
    private String uriToSend;
    private String targetEndpointName;
    private Integer delayBeforeSending = 10000;
    private NMR nmr;

    public String getTargetEndpointName() {
        return this.targetEndpointName;
    }

    public void setTargetEndpointName(String targetEndpointName) {
        this.targetEndpointName = targetEndpointName;
    }

    private void checkConstraints() {
        Assert.notNull((Object)this.dataToSend, (String)"dataToSend property is compulsory");
        Assert.notNull((Object)this.nmr, (String)"nmr property is compulsory");
    }

    public void start() {
        this.checkConstraints();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                try {
                    SimpleClient.this.sendRequestSynchronously();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, this.delayBeforeSending.intValue());
    }

    public ExchangeImpl performSynchronousRequest() throws Exception {
        SoapMarshaler soapMarshaler = new SoapMarshaler();
        soapMarshaler.setUseDom(true);
        JBIMarshaler marshaler = new JBIMarshaler();
        SoapMessage soapMessage = soapMarshaler.createReader().read(ServiceMixSupport.convertStringToIS(this.dataToSend, "UTF8"));
        NormalizedMessageImpl normalizedMessage = new NormalizedMessageImpl((Message)new MessageImpl());
        marshaler.toNMS((NormalizedMessage)normalizedMessage, soapMessage);
        MockSoapHelper helper = new MockSoapHelper();
        Context ctx = helper.createContext(soapMessage);
        MessageExchange messageExchange = helper.onReceive(ctx);
        ExchangeImpl exchange = (ExchangeImpl)((MessageExchangeImpl)messageExchange).getInternalExchange();
        if (this.uriToSend != null) {
            exchange.getIn().setHeader("org.apache.servicemix.http.destination.uri", (Object)this.uriToSend);
        }
        HashMap<String, String> targetProps = new HashMap<String, String>();
        if (this.targetEndpointName == null) {
            this.targetEndpointName = "JustDummyEndpointName";
        }
        targetProps.put("ENDPOINT_NAME", this.targetEndpointName);
        exchange.setTarget(this.nmr.getEndpointRegistry().lookup(targetProps));
        LOG.info((Object)("!!SimpleClient is sending synchronous request with in message " + this.dataToSend));
        this.nmr.createChannel().sendSync((Exchange)exchange);
        return exchange;
    }

    public void sendRequestSynchronously() throws Exception {
        ExchangeImpl exchange = this.performSynchronousRequest();
        if (exchange.getError() != null) {
            LOG.error((Object)"The invocation wasn't successful", (Throwable)exchange.getError());
        }
        if (exchange.getFault() != null && exchange.getFault().getBody() != null) {
            LOG.error((Object)("The invocation wasn't successful " + exchange.getFault().getBody().toString()));
        }
        LOG.info((Object)("!!SimpleClient have received the response: " + new SourceTransformer().toString((Source)exchange.getOut().getBody(Source.class))));
    }

    public String getDataToSend() {
        return this.dataToSend;
    }

    public void setDataToSend(String dataToSend) {
        this.dataToSend = dataToSend;
    }

    public String getUriToSend() {
        return this.uriToSend;
    }

    public void setUriToSend(String uriToSend) {
        this.uriToSend = uriToSend;
    }

    public Integer getDelayBeforeSending() {
        return this.delayBeforeSending;
    }

    public void setDelayBeforeSending(Integer delayBeforeSending) {
        this.delayBeforeSending = delayBeforeSending;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

