/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.springframework.util.Assert;

public class StringSource
extends StreamSource {
    private String text;
    private String encoding;

    public StringSource(String text) {
        this(text, null, "UTF-8");
    }

    public StringSource(String text, String systemId, String encoding) {
        Assert.notNull((Object)text, (String)"text can not be null");
        this.text = text;
        this.encoding = encoding;
        if (systemId != null) {
            this.setSystemId(systemId);
        }
    }

    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.text.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getReader() {
        return new StringReader(this.text);
    }

    public String toString() {
        return "StringSource[" + this.text + "]";
    }

    public String getText() {
        return this.text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object obj) {
        return this.getText().equals(((StringSource)obj).getText());
    }
}

