/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.exception;

import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.event.Event;
import org.eclipse.swordfish.core.event.EventService;
import org.eclipse.swordfish.internal.core.exception.InterceptorExceptionEvent;
import org.eclipse.swordfish.internal.core.util.AopProxyUtil;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorExceptionNotificationSender
implements BundleContextAware {
    private static final Log LOG = LogFactory.getLog(InterceptorExceptionNotificationSender.class);
    public static final String EXCEPTION_TOPIC = "org/eclipse/swordfish/api/interceptor/EXCEPTION";
    public static final String EXEPTION_EVENT_PROPERTY = "exeption.event.property";
    public static final String EXCHANGE_EVENT_PROPERTY = "exchange.event.property";
    public static final String INTERCEPTOR_EVENT_PROPERTY = "interceptor.event.property";
    private BundleContext bundleContext;
    private EventService eventService;

    public <T extends Interceptor> void sendNotification(Exception exception, MessageExchange exchange, T interceptor) {
        LOG.debug((Object)String.format("received exception [%s] thrown during [%s] interceptor work for message exchange [%s]", exception, interceptor.getClass().getName(), exchange));
        LOG.debug((Object)"Proceed to sending notification event");
        InterceptorExceptionEvent event = new InterceptorExceptionEvent(exception, exchange, (Interceptor)AopProxyUtil.getTargetService(interceptor, (BundleContext)this.bundleContext));
        this.eventService.postEvent((Event)event);
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

