/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.backend.ClientRequest;
import org.eclipse.swordfish.core.resolver.backend.ClientResponse;
import org.eclipse.swordfish.core.resolver.backend.ProxyConstants;
import org.eclipse.swordfish.internal.resolver.backend.base.AbstractProxy;
import org.eclipse.swordfish.internal.resolver.backend.base.RegistryProxyFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientProxy
extends AbstractProxy {
    private static final Log LOG = LogFactory.getLog(HttpClientProxy.class);
    private HttpClient client = new HttpClient();

    @Override
    protected ClientResponse invoke(ClientRequest request) {
        ClientResponse response = null;
        Assert.notNull((Object)request, (String)"Unexpected object state: ClientRequest cannot be null.");
        Assert.notNull((Object)request.getMethod(), (String)"Unexpected object state: request method cannot be null.");
        Assert.notNull((Object)request.getURI(), (String)"Unexpected object state: request URI cannot be null.");
        try {
            response = this.doInvoke(request);
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't execute " + request.getMethod() + " request: "), (Throwable)e);
            throw new SwordfishException("Couldn't execute " + request.getMethod() + " method: ", (Throwable)e);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClientResponse doInvoke(ClientRequest request) {
        ClientResponse response = RegistryProxyFactory.getInstance().createResponse();
        HttpMethod method = this.getMethod(request.getMethod());
        try {
            try {
                String escapedRequestUrl = request.getURI().toASCIIString();
                HttpURL requestUrl = new HttpURL(escapedRequestUrl.toCharArray());
                if (request.getProperties() != null) {
                    Map properties = request.getProperties();
                    String[] queryNames = properties.keySet().toArray(new String[0]);
                    String[] queryValues = properties.values().toArray(new String[0]);
                    requestUrl.setQuery(queryNames, queryValues);
                }
                method.setURI((URI)requestUrl);
                int statusCode = this.getClient().executeMethod(method);
                response.setStatus(ProxyConstants.Status.get((int)statusCode));
                String responseBody = method.getResponseBodyAsString();
                if (request.getEntityType() != null) {
                    response.setEntity(this.mapResponse(responseBody, request.getEntityType()));
                    return response;
                } else {
                    response.setEntity((Object)responseBody);
                }
                return response;
            }
            catch (HttpException e) {
                LOG.error((Object)"Couldn't perform call to registry: ", (Throwable)e);
                response.setStatus(ProxyConstants.Status.ERROR);
                response.setEntity((Object)e);
                if (method == null) return response;
                method.releaseConnection();
                return response;
            }
            catch (IOException e) {
                LOG.error((Object)"Couldn't perform call to registry: ", (Throwable)e);
                response.setStatus(ProxyConstants.Status.ERROR);
                response.setEntity((Object)e);
                if (method == null) return response;
                method.releaseConnection();
                return response;
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected HttpMethod getMethod(ProxyConstants.Method method) {
        GetMethod result = null;
        if (method.equals((Object)ProxyConstants.Method.GET)) {
            result = new GetMethod();
        } else if (method.equals((Object)ProxyConstants.Method.POST)) {
            result = new PostMethod();
        } else if (method.equals((Object)ProxyConstants.Method.DELETE)) {
            result = new DeleteMethod();
        } else if (method.equals((Object)ProxyConstants.Method.PUT)) {
            result = new PutMethod();
        }
        return result;
    }

    private Object mapResponse(String response, Class<? extends Object> etnityType) {
        Object responseObject = null;
        StringReader responseReader = new StringReader(response);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            responseObject = JAXB.unmarshal((Reader)responseReader, etnityType);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return responseObject;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }
}

