/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.PolicyResource;
import org.eclipse.swordfish.registry.WSDLRepository;

public class PolicyServlet
extends HttpServlet {
    private static final long serialVersionUID = -8376659320998034145L;
    private static final Log LOGGER = LogFactory.getLog(PolicyServlet.class);
    private WSDLRepository repository;

    /*
     * Enabled aggressive block sorting
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info((Object)("Received request:\n" + req.getRequestURL()));
        PolicyResource resource = null;
        if (!req.getParameterMap().isEmpty()) {
            resp.sendError(400);
            return;
        }
        String resourceId = PolicyServlet.getResourceId(req);
        if (resourceId == null) {
            resp.sendError(400);
            return;
        }
        resource = this.repository.getPolicy(resourceId);
        if (resource == null) {
            resp.sendError(404);
            return;
        }
        resp.setContentType(resource.getContentType());
        resp.setCharacterEncoding(resource.getCharacterEncoding());
        resource.appendContent(resp.getWriter());
    }

    public void setRepository(WSDLRepository repository) {
        this.repository = repository;
    }

    private static String getResourceId(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 1) {
            return pathInfo.substring(1);
        }
        return null;
    }
}

