/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.PolicyServlet;
import org.eclipse.swordfish.registry.RegistryException;
import org.eclipse.swordfish.registry.WSDLServlet;
import org.eclipse.swordfish.registry.WSILServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletActivator {
    private static final String WSDL_SERVLET_ALIAS = "/registry/wsdl";
    private static final String WSIL_SERVLET_ALIAS = "/registry/wsil";
    private static final String POLICY_SERVLET_ALIAS = "/registry/policy";
    private static final String STYLESHEET_RESOURCE_ALIAS = "/registry/resources/stylesheets";
    private static final String IMAGE_RESOURCE_ALIAS = "/registry/resources/images";
    private static String webParam = "wsdlLocation";
    private static final String LOCATION_PROPERTY = "org.eclipse.swordfish.registry.fileLocation";
    private static final Log LOGGER = LogFactory.getLog(ServletActivator.class);
    private WSDLServlet wsdlServlet;
    private WSILServlet wsilServlet;
    private PolicyServlet policyServlet;
    private HttpService httpService;

    public void start() throws RegistryException {
        LOGGER.info((Object)"Starting the LookupServlet.");
        Hashtable<String, String> params = ServletActivator.getParams();
        try {
            this.httpService.registerServlet(WSDL_SERVLET_ALIAS, (Servlet)this.wsdlServlet, params, null);
        }
        catch (ServletException e) {
            ServletActivator.throwRegistryException("The initialization of the WSDLServlet failed.", e);
        }
        catch (NamespaceException e) {
            ServletActivator.throwRegistryException("The LookupServlet cannot be registered under the alias /registry/wsdl because another servlet is already registered under this name", e);
        }
        try {
            this.httpService.registerServlet(WSIL_SERVLET_ALIAS, (Servlet)this.wsilServlet, params, null);
        }
        catch (ServletException e) {
            ServletActivator.throwRegistryException("The initialization of the WSILServlet failed.", e);
        }
        catch (NamespaceException e) {
            ServletActivator.throwRegistryException("The LookupServlet cannot be registered under the alias /registry/wsil because another servlet is already registered under this name", e);
        }
        try {
            this.httpService.registerServlet(POLICY_SERVLET_ALIAS, (Servlet)this.policyServlet, params, null);
        }
        catch (ServletException e) {
            ServletActivator.throwRegistryException("The initialization of the PolicyServlet failed.", e);
        }
        catch (NamespaceException e) {
            ServletActivator.throwRegistryException("The LookupServlet cannot be registered under the alias /registry/policy because another servlet is already registered under this name", e);
        }
        try {
            this.httpService.registerResources(STYLESHEET_RESOURCE_ALIAS, "/stylesheets", null);
        }
        catch (NamespaceException e) {
            ServletActivator.throwRegistryException("The stylesheet resources cannot be registered under the alias /registry/resources/stylesheets because another servlet is already registered under this name", e);
        }
        try {
            this.httpService.registerResources(IMAGE_RESOURCE_ALIAS, "/images", null);
        }
        catch (NamespaceException e) {
            ServletActivator.throwRegistryException("The stylesheet resources cannot be registered under the alias /registry/resources/stylesheets because another servlet is already registered under this name", e);
        }
    }

    public void stop() {
        LOGGER.info((Object)"Stoping the LookupServlet.");
        this.httpService.unregister(WSDL_SERVLET_ALIAS);
        this.httpService.unregister(WSIL_SERVLET_ALIAS);
    }

    public void setWsdlServlet(WSDLServlet servlet) {
        this.wsdlServlet = servlet;
    }

    public void setWsilServlet(WSILServlet servlet) {
        this.wsilServlet = servlet;
    }

    public void setPolicyServlet(PolicyServlet servlet) {
        this.policyServlet = servlet;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    private static Hashtable<String, String> getParams() throws RegistryException {
        String fileLocation = System.getProperty(LOCATION_PROPERTY);
        if (fileLocation == null) {
            ServletActivator.throwRegistryException("The system property org.eclipse.swordfish.registry.fileLocation is not defined.", null);
        }
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put(webParam, fileLocation);
        return params;
    }

    private static void throwRegistryException(String errorMessage, Throwable e) throws RegistryException {
        LOGGER.error((Object)errorMessage);
        throw new RegistryException(errorMessage, e);
    }
}

