/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.swordfish.registry.DefaultResource;
import org.eclipse.swordfish.registry.PolicyResource;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.WSDLRepository;
import org.eclipse.swordfish.registry.domain.Binding;
import org.eclipse.swordfish.registry.domain.PortType;
import org.eclipse.swordfish.registry.domain.Service;

public class WSDLListHtmlResource
extends DefaultResource
implements Resource {
    public static final String PREFIX = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>Registry</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/registry/resources/stylesheets/registry.css\"/></head>\n<body>\n<img src=\"/registry/resources/images/Swordfish_smaller_logo1.png\" alt=\"Swordfish logo\">\n\n<table>\n";
    public static final String POSTFIX = "</table>\n</body>\n</html>\n";
    public static final String TABLE_HEADER = "<thead>  <tr>    <th>PortType</th>    <th>Service</th>    <th>Policy</th>  </tr></thead>";
    private String baseUrl;
    private WSDLRepository repository;

    public WSDLListHtmlResource(String baseUrl, WSDLRepository repository) {
        this.baseUrl = baseUrl;
        this.repository = repository;
    }

    public String getId() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getCharacterEncoding() {
        return "utf-8";
    }

    public String getContentType() {
        return "text/html";
    }

    public void get(Writer writer) throws IOException {
        this.appendContent(writer);
    }

    public void appendContent(Writer writer) throws IOException {
        writer.append(PREFIX);
        writer.append(TABLE_HEADER);
        TableRow row = new TableRow();
        Iterable<PortType> portTypes = this.repository.getAllPortTypes();
        for (PortType portType : portTypes) {
            row.setColumnOne("<a href=\"" + this.baseUrl + "/wsdl/" + portType.getWSDL().getId() + "\">" + portType.getQName().toString() + "</a>");
            for (Binding binding : portType.getBindings()) {
                for (Service service : binding.getServices()) {
                    row.setColumnTwo("<a href=\"" + this.baseUrl + "/wsdl/" + service.getWSDL().getId() + "\">" + service.getQName().toString() + "</a>");
                    for (PolicyResource policyResource : binding.getPolicies()) {
                        row.setColumnThree("<a href=\"" + this.baseUrl + "/policy/" + policyResource.getId() + "\">" + policyResource.getId() + "</a>");
                        this.writeAndReset(row, writer);
                    }
                    this.writeAndReset(row, writer);
                }
            }
            this.writeAndReset(row, writer);
        }
        writer.append(POSTFIX);
    }

    private void writeAndReset(TableRow row, Writer writer) throws IOException {
        if (row.oneColumnDefined()) {
            row.writeTo(writer);
            row.reset();
        }
    }

    static class TableRow {
        private String columnOne = "";
        private String columnTwo = "";
        private String columnThree = "";

        TableRow() {
        }

        public void setColumnOne(String value) {
            this.columnOne = value;
        }

        public void setColumnTwo(String value) {
            this.columnTwo = value;
        }

        public void setColumnThree(String value) {
            this.columnThree = value;
        }

        public void reset() {
            this.columnOne = "";
            this.columnTwo = "";
            this.columnThree = "";
        }

        public boolean oneColumnDefined() {
            return this.columnOne.length() > 0 || this.columnTwo.length() > 0 || this.columnThree.length() > 0;
        }

        public void writeTo(Writer writer) throws IOException {
            writer.append("<tr> <td>");
            writer.append(this.columnOne);
            writer.append("</td><td>");
            writer.append(this.columnTwo);
            writer.append("</td><td>");
            writer.append(this.columnThree);
            writer.append("</td></tr>");
        }
    }
}

