/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.cxf;

import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.samples.cxf.BookingService;
import org.eclipse.swordfish.samples.cxf.domain.Flight;
import org.eclipse.swordfish.samples.cxf.domain.Passenger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BookingServiceClientInvoker
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(BookingServiceClientInvoker.class);
    private Integer delayBeforeSending = 5000;
    private BookingService bookingService;

    public BookingService getBookingService() {
        return this.bookingService;
    }

    public void setBookingService(BookingService bookingService) {
        this.bookingService = bookingService;
    }

    public Integer getDelayBeforeSending() {
        return this.delayBeforeSending;
    }

    public void setDelayBeforeSending(Integer delayBeforeSending) {
        this.delayBeforeSending = delayBeforeSending;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.bookingService);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                try {
                    BookingServiceClientInvoker.this.performRequest();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, this.delayBeforeSending.intValue());
    }

    private void performRequest() {
        LOG.info((Object)"Pefforming invocation on bookingService");
        int id = this.bookingService.createReservation(Arrays.asList(new Passenger(5, "Homer", "Simpson", 43), new Passenger(6, "Marge", "Simpson", 42)), new Flight(10, "SP101"));
        LOG.info((Object)("The reservation was created with id = " + id));
    }
}

