/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class AndFilter
implements PacketFilter {
    private int size;
    private PacketFilter[] filters;

    public AndFilter() {
        this.size = 0;
        this.filters = new PacketFilter[3];
    }

    public AndFilter(PacketFilter filter1, PacketFilter filter2) {
        if (filter1 == null || filter2 == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.size = 2;
        this.filters = new PacketFilter[2];
        this.filters[0] = filter1;
        this.filters[1] = filter2;
    }

    public void addFilter(PacketFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        if (this.size == this.filters.length) {
            PacketFilter[] newFilters = new PacketFilter[this.filters.length + 2];
            int i = 0;
            while (i < this.filters.length) {
                newFilters[i] = this.filters[i];
                ++i;
            }
            this.filters = newFilters;
        }
        this.filters[this.size] = filter;
        ++this.size;
    }

    public boolean accept(Packet packet) {
        int i = 0;
        while (i < this.size) {
            if (!this.filters[i].accept(packet)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.filters.toString();
    }
}

