/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.ConnectionEstablishedListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class ServiceDiscoveryManager {
    private static String identityName = "Smack";
    private static String identityType = "pc";
    private static Map instances = new Hashtable();
    private XMPPConnection connection;
    private List features = new ArrayList();
    private Map nodeInformationProviders = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        XMPPConnection.addConnectionListener(new ConnectionEstablishedListener(){

            public void connectionEstablished(XMPPConnection connection) {
                new ServiceDiscoveryManager(connection);
            }
        });
    }

    public ServiceDiscoveryManager(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    public static ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        return (ServiceDiscoveryManager)instances.get(connection);
    }

    public static String getIdentityName() {
        return identityName;
    }

    public static void setIdentityName(String name) {
        identityName = name;
    }

    public static String getIdentityType() {
        return identityType;
    }

    public static void setIdentityType(String type) {
        identityType = type;
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                instances.remove(ServiceDiscoveryManager.this.connection);
            }

            public void connectionClosedOnError(Exception e) {
                instances.remove(ServiceDiscoveryManager.this.connection);
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jivesoftware.smackx.packet.DiscoverItems");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PacketTypeFilter packetFilter = new PacketTypeFilter(clazz);
        PacketListener packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems response = new DiscoverItems();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverItems.getFrom());
                    response.setPacketID(discoverItems.getPacketID());
                    if (ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode()) != null) {
                        Iterator items = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode()).getNodeItems();
                        while (items.hasNext()) {
                            response.addItem((DiscoverItems.Item)items.next());
                        }
                    } else if (discoverItems.getNode() != null) {
                        response.setNode(discoverItems.getNode());
                        response.setType(IQ.Type.ERROR);
                        response.setError(new XMPPError(404, "item-not-found"));
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetFilter);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jivesoftware.smackx.packet.DiscoverInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        packetFilter = new PacketTypeFilter(clazz2);
        packetListener = new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processPacket(Packet packet) {
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo response = new DiscoverInfo();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverInfo.getFrom());
                    response.setPacketID(discoverInfo.getPacketID());
                    if (discoverInfo.getNode() == null) {
                        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", ServiceDiscoveryManager.getIdentityName());
                        identity.setType(ServiceDiscoveryManager.getIdentityType());
                        response.addIdentity(identity);
                        List list = ServiceDiscoveryManager.this.features;
                        synchronized (list) {
                            Iterator it = ServiceDiscoveryManager.this.getFeatures();
                            while (it.hasNext()) {
                                response.addFeature((String)it.next());
                            }
                        }
                    } else {
                        response.setNode(discoverInfo.getNode());
                        response.setType(IQ.Type.ERROR);
                        response.setError(new XMPPError(404, "item-not-found"));
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetFilter);
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return (NodeInformationProvider)this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFeatures() {
        List list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        List list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        List list = this.features;
        synchronized (list) {
            this.features.remove(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String feature) {
        List list = this.features;
        synchronized (list) {
            return this.features.contains(feature);
        }
    }

    public DiscoverInfo discoverInfo(String entityID) throws XMPPException {
        return this.discoverInfo(entityID, null);
    }

    public DiscoverInfo discoverInfo(String entityID, String node) throws XMPPException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket(disco);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(String entityID) throws XMPPException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws XMPPException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket(disco);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(String entityID) throws XMPPException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String entityID, DiscoverItems discoverItems) throws XMPPException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(String entityID, String node, DiscoverItems discoverItems) throws XMPPException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(discoverItems.getPacketID()));
        this.connection.sendPacket(discoverItems);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }
}

