/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;

public class DiscoverInfo
extends IQ {
    private List features = new ArrayList();
    private List identities = new ArrayList();
    private String node;

    public void addFeature(String feature) {
        this.addFeature(new Feature(feature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeature(Feature feature) {
        List list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getFeatures() {
        List list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity) {
        List list = this.identities;
        synchronized (list) {
            this.identities.add(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getIdentities() {
        List list = this.identities;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.identities)).iterator();
        }
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean containsFeature(String feature) {
        Iterator it = this.getFeatures();
        while (it.hasNext()) {
            if (!feature.equals(((Feature)it.next()).getVar())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("<query xmlns=\"http://jabber.org/protocol/disco#info\"");
        if (this.getNode() != null) {
            buf.append(" node=\"");
            buf.append(this.getNode());
            buf.append("\"");
        }
        buf.append(">");
        List list = this.identities;
        synchronized (list) {
            i = 0;
            while (i < this.identities.size()) {
                Identity identity = (Identity)this.identities.get(i);
                buf.append(identity.toXML());
                ++i;
            }
        }
        list = this.features;
        synchronized (list) {
            i = 0;
            while (i < this.features.size()) {
                Feature feature = (Feature)this.features.get(i);
                buf.append(feature.toXML());
                ++i;
            }
        }
        buf.append(this.getExtensionsXML());
        buf.append("</query>");
        return buf.toString();
    }

    public static class Feature {
        private String variable;

        public Feature(String variable) {
            this.variable = variable;
        }

        public String getVar() {
            return this.variable;
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<feature var=\"").append(this.variable).append("\"/>");
            return buf.toString();
        }
    }

    public static class Identity {
        private String category;
        private String name;
        private String type;

        public Identity(String category, String name) {
            this.category = category;
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<identity category=\"").append(this.category).append("\"");
            buf.append(" name=\"").append(this.name).append("\"");
            if (this.type != null) {
                buf.append(" type=\"").append(this.type).append("\"");
            }
            buf.append("/>");
            return buf.toString();
        }
    }
}

