/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.osgi.util.DebugUtils;
import org.springframework.osgi.util.OsgiFilterUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.osgi.util.internal.ClassUtils;

abstract class TrackingUtil {
    private static final Log log = LogFactory.getLog((Class)TrackingUtil.class);

    TrackingUtil() {
    }

    public static Object getService(Class[] classes, String filter, ClassLoader classLoader, BundleContext context, Object fallbackObject) {
        ProxyFactory factory = new ProxyFactory();
        ClassUtils.configureFactoryForClass(factory, classes);
        String flt = OsgiFilterUtils.unifyFilter(classes, filter);
        factory.addAdvice((Advice)new MethodInvocationServiceAdvice(fallbackObject, context, flt));
        try {
            return factory.getProxy(classLoader);
        }
        catch (NoClassDefFoundError ncdfe) {
            if (log.isWarnEnabled()) {
                DebugUtils.debugClassLoadingThrowable(ncdfe, context.getBundle(), classes);
            }
            throw ncdfe;
        }
    }

    private static class MethodInvocationServiceAdvice
    implements MethodInterceptor {
        private final Object fallbackObject;
        private final BundleContext context;
        private final String filter;

        public MethodInvocationServiceAdvice(Object fallbackObject, BundleContext bundleContext, String filter) {
            this.fallbackObject = fallbackObject;
            this.context = bundleContext;
            this.filter = filter;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method m = invocation.getMethod();
            Object target = this.context.getService(OsgiServiceReferenceUtils.getServiceReference(this.context, this.filter));
            if (target == null) {
                target = this.fallbackObject;
            }
            return m.invoke(target, invocation.getArguments());
        }
    }
}

