/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.dependency.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ConcurrentMap;
import org.springframework.osgi.service.dependency.DependableServiceImporter;
import org.springframework.osgi.service.dependency.DependentServiceExporter;
import org.springframework.osgi.service.dependency.MandatoryDependencyEvent;
import org.springframework.osgi.service.dependency.MandatoryDependencyListener;
import org.springframework.osgi.service.dependency.ServiceDependency;
import org.springframework.osgi.service.dependency.internal.MandatoryServiceDependencyManager;
import org.springframework.osgi.util.internal.BeanFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultMandatoryDependencyManager
implements MandatoryServiceDependencyManager,
BeanFactoryAware,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)DefaultMandatoryDependencyManager.class);
    private final Map importers = CollectionFactory.createConcurrentMap((int)4);
    private final Map exporters = CollectionFactory.createConcurrentMap((int)4);
    private final ConcurrentMap importersSeen = CollectionFactory.createConcurrentMap((int)4);
    private final ConcurrentMap exportersSeen = CollectionFactory.createConcurrentMap((int)4);
    private static final Object VALUE = new Object();
    private final Map importerToExportersDeps = CollectionFactory.createConcurrentMap((int)8);
    private final Map exporterToImporterDeps = CollectionFactory.createConcurrentMap((int)8);
    private ConfigurableListableBeanFactory beanFactory;
    private final MandatoryDependencyListener importerListener = new ImportersListeners();

    public void addServiceExporter(String exporterBeanName) {
        Assert.hasText((String)exporterBeanName);
        if (this.exportersSeen.putIfAbsent((Object)exporterBeanName, VALUE) == null) {
            String beanName = exporterBeanName;
            if (this.beanFactory.isFactoryBean(exporterBeanName)) {
                beanName = "&" + exporterBeanName;
            }
            if (!this.beanFactory.isSingleton(beanName)) {
                log.trace((Object)("exporter [" + beanName + "] is not singleton and will not be tracked"));
            } else {
                DependentServiceExporter exporter = (DependentServiceExporter)this.beanFactory.getBean(beanName);
                exporter.setPublishAtStartup(false);
                this.discoverDependentImporterFor(exporterBeanName, exporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverDependentImporterFor(String exporterBeanName, DependentServiceExporter exporter) {
        boolean trace = log.isTraceEnabled();
        this.exporters.put(exporterBeanName, exporter);
        Object[] importerNames = BeanFactoryUtils.getTransitiveDependenciesForBean(this.beanFactory, exporterBeanName, true, DependableServiceImporter.class);
        LinkedHashMap<DependableServiceImporter, Object> importers = new LinkedHashMap<DependableServiceImporter, Object>(importerNames.length);
        if (trace) {
            log.trace((Object)("exporter [" + exporterBeanName + "] depends (transitively) on the following importers:" + ObjectUtils.nullSafeToString((Object[])importerNames)));
        }
        for (int i = 0; i < importerNames.length; ++i) {
            if (this.beanFactory.isSingleton(importerNames[i])) {
                DependableServiceImporter importer = (DependableServiceImporter)this.beanFactory.getBean((String)importerNames[i]);
                if (importer.isMandatory()) {
                    importers.put(importer, importerNames[i]);
                    MandatoryDependencyListener mandatoryDependencyListener = this.importerListener;
                    synchronized (mandatoryDependencyListener) {
                        if (this.importersSeen.putIfAbsent((Object)importer, importerNames[i]) == null) {
                            importer.registerListener(this.importerListener);
                        }
                        continue;
                    }
                }
                if (!trace) continue;
                log.trace((Object)("importer [" + (String)importerNames[i] + "] is optional; skipping it"));
                continue;
            }
            if (!trace) continue;
            log.trace((Object)("importer [" + (String)importerNames[i] + "] is a non-singleton; ignoring it"));
        }
        if (trace) {
            log.trace((Object)("after filtering, exporter [" + exporterBeanName + "] depends on importers:" + importers.values()));
        }
        Set imps = importers.keySet();
        Iterator iter = imps.iterator();
        while (iter.hasNext()) {
            DependableServiceImporter importer;
            DependableServiceImporter dependableServiceImporter = importer = (DependableServiceImporter)iter.next();
            synchronized (dependableServiceImporter) {
                ArrayList<DependentServiceExporter> exporters = (ArrayList<DependentServiceExporter>)this.importerToExportersDeps.get(importer);
                if (exporters == null) {
                    exporters = new ArrayList<DependentServiceExporter>(2);
                }
                exporters.add(exporter);
                this.importerToExportersDeps.put(importer, exporters);
            }
        }
        DependentServiceExporter dependentServiceExporter = exporter;
        synchronized (dependentServiceExporter) {
            LinkedHashMap<DependableServiceImporter, Boolean> importerStatuses = new LinkedHashMap<DependableServiceImporter, Boolean>(imps.size());
            Iterator iter2 = imps.iterator();
            while (iter2.hasNext()) {
                DependableServiceImporter imp = (DependableServiceImporter)iter2.next();
                importerStatuses.put(imp, imp.isSatisfied());
            }
            this.exporterToImporterDeps.put(exporter, importerStatuses);
            if (!importerStatuses.containsValue(Boolean.FALSE)) {
                exporter.start();
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf((Class)ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void destroy() {
        this.importers.clear();
        this.exporters.clear();
        this.importersSeen.clear();
        this.exportersSeen.clear();
    }

    private class ImportersListeners
    implements MandatoryDependencyListener {
        private ImportersListeners() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mandatoryDependencySatisfied(MandatoryDependencyEvent event) {
            boolean trace = log.isTraceEnabled();
            ServiceDependency importer = event.getServiceImporter();
            Iterator iter = ((List)DefaultMandatoryDependencyManager.this.importerToExportersDeps.get(importer)).iterator();
            while (iter.hasNext()) {
                DependentServiceExporter exporter;
                DependentServiceExporter dependentServiceExporter = exporter = (DependentServiceExporter)iter.next();
                synchronized (dependentServiceExporter) {
                    Map importers = (Map)DefaultMandatoryDependencyManager.this.exporterToImporterDeps.get(exporter);
                    importers.put(event.getServiceImporter(), Boolean.TRUE);
                    if (!importers.containsValue(Boolean.FALSE)) {
                        exporter.start();
                        if (trace) {
                            log.trace((Object)("exporter " + exporter + " can be registered; all its exporterToImporterDeps are satisfied"));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mandatoryDependencyUnsatisfied(MandatoryDependencyEvent event) {
            boolean trace = log.isTraceEnabled();
            ServiceDependency importer = event.getServiceImporter();
            Iterator iter = ((List)DefaultMandatoryDependencyManager.this.importerToExportersDeps.get(importer)).iterator();
            while (iter.hasNext()) {
                DependentServiceExporter exporter = (DependentServiceExporter)iter.next();
                if (trace) {
                    log.trace((Object)("exporter " + exporter + " is stopped; one of its exporterToImporterDeps disappeared"));
                }
                exporter.stop();
                DependentServiceExporter dependentServiceExporter = exporter;
                synchronized (dependentServiceExporter) {
                    Map importers = (Map)DefaultMandatoryDependencyManager.this.exporterToImporterDeps.get(exporter);
                    importers.put(importer, Boolean.FALSE);
                }
            }
        }
    }
}

