/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedHashSet;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.support.internal.OsgiBundleScope;
import org.springframework.osgi.service.exporter.OsgiServicePropertiesResolver;
import org.springframework.osgi.service.exporter.support.AbstractOsgiServiceExporter;
import org.springframework.osgi.service.exporter.support.AutoExport;
import org.springframework.osgi.service.exporter.support.BeanNameServicePropertiesResolver;
import org.springframework.osgi.service.exporter.support.ExportContextClassLoader;
import org.springframework.osgi.service.importer.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.util.DebugUtils;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class OsgiServiceFactoryBean
extends AbstractOsgiServiceExporter
implements BeanFactoryAware,
DisposableBean,
BundleContextAware,
FactoryBean,
Ordered,
BeanClassLoaderAware,
BeanNameAware {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceFactoryBean.class);
    private BundleContext bundleContext;
    private OsgiServicePropertiesResolver propertiesResolver;
    private BeanFactory beanFactory;
    private ServiceRegistration serviceRegistration;
    private Map serviceProperties;
    private int ranking;
    private String targetBeanName;
    private boolean hasNamedBean;
    private Class[] interfaces;
    private AutoExport autoExport = AutoExport.DISABLED;
    private ExportContextClassLoader contextClassLoader = ExportContextClassLoader.UNMANAGED;
    private Object target;
    private Class targetClass;
    private int order = Integer.MAX_VALUE;
    private ClassLoader classLoader;
    private String beanName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"required property 'beanFactory' has not been set");
        Assert.notNull((Object)this.bundleContext, (String)"required property 'bundleContext' has not been set");
        this.hasNamedBean = StringUtils.hasText((String)this.targetBeanName);
        Assert.isTrue((this.hasNamedBean || this.target != null ? 1 : 0) != 0, (String)"either 'targetBeanName' or 'target' properties have to be set");
        if (this.hasNamedBean) {
            if (this.beanFactory.isSingleton(this.targetBeanName)) {
                this.target = this.beanFactory.getBean(this.targetBeanName);
                this.targetClass = this.target.getClass();
            } else {
                this.targetClass = this.beanFactory.getType(this.targetBeanName);
            }
        } else {
            this.targetClass = this.target.getClass();
        }
        if (this.propertiesResolver == null) {
            this.propertiesResolver = new BeanNameServicePropertiesResolver();
            ((BeanNameServicePropertiesResolver)this.propertiesResolver).setBundleContext(this.bundleContext);
        }
        if (this.interfaces == null) {
            this.interfaces = new Class[0];
        }
        super.afterPropertiesSet();
    }

    private Object wrapWithClassLoaderManagingProxy(Object target, Class[] interfaces) {
        ProxyFactory factory = new ProxyFactory();
        ClassUtils.configureFactoryForClass(factory, interfaces);
        factory.addAdvice((Advice)new ServiceTCCLInterceptor(this.classLoader));
        factory.setTarget(target);
        factory.setFrozen(true);
        try {
            return factory.getProxy(this.classLoader);
        }
        catch (Throwable th) {
            log.error((Object)"cannot create TCCL managed proxy; falling back to the naked object", th);
            if (th instanceof NoClassDefFoundError) {
                NoClassDefFoundError ncdfe = (NoClassDefFoundError)th;
                if (log.isWarnEnabled()) {
                    DebugUtils.debugClassLoadingThrowable(ncdfe, this.bundleContext.getBundle(), this.interfaces);
                }
                throw ncdfe;
            }
            return target;
        }
    }

    private Dictionary mergeServiceProperties(String beanName) {
        MapBasedDictionary props = new MapBasedDictionary(this.propertiesResolver.getServiceProperties(beanName));
        props.putAll((Map)props);
        if (this.serviceProperties != null) {
            props.putAll(this.serviceProperties);
        }
        if (this.ranking != 0) {
            props.put("service.ranking", new Integer(this.ranking));
        }
        return props;
    }

    public void registerService() {
        String beanName = !this.hasNamedBean ? ObjectUtils.getIdentityHexString((Object)this.target) : this.targetBeanName;
        Dictionary serviceProperties = this.mergeServiceProperties(beanName);
        Class[] intfs = this.interfaces;
        Object[] autoDetectedClasses = this.autoExport.getExportedClasses(this.targetClass);
        if (log.isTraceEnabled()) {
            log.trace((Object)("autoexport mode [" + (Object)((Object)this.autoExport) + "] discovered on class [" + this.targetClass + "] classes " + ObjectUtils.nullSafeToString((Object[])autoDetectedClasses)));
        }
        LinkedHashSet classes = new LinkedHashSet(intfs.length + autoDetectedClasses.length);
        CollectionUtils.mergeArrayIntoCollection((Object)intfs, classes);
        CollectionUtils.mergeArrayIntoCollection((Object)autoDetectedClasses, classes);
        Class[] mergedClasses = classes.toArray(new Class[classes.size()]);
        ServiceRegistration reg = this.registerService(mergedClasses, serviceProperties);
        this.serviceRegistration = this.notifyListeners(this.target, (Map)((Object)serviceProperties), reg);
    }

    ServiceRegistration registerService(Class[] classes, Dictionary serviceProperties) {
        Assert.notEmpty((Object[])classes, (String)"at least one class has to be specified for exporting (if autoExport is enabled then maybe the object doesn't implement any interface)");
        ClassLoader beanClassLoader = ClassUtils.getClassLoader(this.targetClass);
        Class[] visibleClasses = ClassUtils.getVisibleClasses(classes, beanClassLoader);
        Object[] names = ClassUtils.toStringArray(visibleClasses);
        Arrays.sort(names);
        log.info((Object)("Publishing service under classes [" + ObjectUtils.nullSafeToString((Object[])names) + "]"));
        Object serviceFactory = new PublishingServiceFactory(visibleClasses);
        if (this.isBeanBundleScoped()) {
            serviceFactory = new OsgiBundleScope.BundleScopeServiceFactory((ServiceFactory)serviceFactory);
        }
        return this.bundleContext.registerService((String[])names, serviceFactory, serviceProperties);
    }

    boolean isBeanBundleScoped() {
        boolean bundleScoped = false;
        if (this.targetBeanName != null) {
            if (this.beanFactory instanceof ConfigurableListableBeanFactory) {
                String beanScope = ((ConfigurableListableBeanFactory)this.beanFactory).getMergedBeanDefinition(this.targetBeanName).getScope();
                bundleScoped = "bundle".equals(beanScope);
            } else {
                bundleScoped = true;
            }
        }
        return bundleScoped;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getObject() throws Exception {
        return this.serviceRegistration;
    }

    public Class getObjectType() {
        return this.serviceRegistration != null ? this.serviceRegistration.getClass() : ServiceRegistration.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void destroy() {
        this.stop();
    }

    public void unregisterService() {
        this.unregisterService(this.serviceRegistration);
        this.serviceRegistration = null;
    }

    void unregisterService(ServiceRegistration registration) {
        if (OsgiServiceUtils.unregisterService(registration)) {
            log.info((Object)("Unregistered service [" + registration + "]"));
        }
    }

    public void setContextClassLoader(ExportContextClassLoader ccl) {
        Assert.notNull((Object)((Object)ccl));
        this.contextClassLoader = ccl;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetBeanName(String name) {
        this.targetBeanName = name;
    }

    public void setAutoExport(AutoExport classExporter) {
        Assert.notNull((Object)((Object)classExporter));
        this.autoExport = classExporter;
    }

    public Map getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public OsgiServicePropertiesResolver getResolver() {
        return this.propertiesResolver;
    }

    public void setResolver(OsgiServicePropertiesResolver resolver) {
        this.propertiesResolver = resolver;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    private class PublishingServiceFactory
    implements ServiceFactory {
        private ServiceFactory serviceFactory;
        private Class[] classes;

        protected PublishingServiceFactory(Class[] classes) {
            this.classes = classes;
        }

        public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
            Object bean;
            Object object = bean = OsgiServiceFactoryBean.this.target != null ? OsgiServiceFactoryBean.this.target : OsgiServiceFactoryBean.this.beanFactory.getBean(OsgiServiceFactoryBean.this.targetBeanName);
            if (bean instanceof ServiceFactory) {
                this.serviceFactory = (ServiceFactory)bean;
                bean = this.serviceFactory.getService(bundle, serviceRegistration);
            }
            if (OsgiServiceFactoryBean.this.contextClassLoader == ExportContextClassLoader.SERVICE_PROVIDER) {
                Object proxy = OsgiServiceFactoryBean.this.wrapWithClassLoaderManagingProxy(bean, this.classes);
                return proxy;
            }
            return bean;
        }

        public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object bean) {
            if (this.serviceFactory != null) {
                this.serviceFactory.ungetService(bundle, serviceRegistration, bean);
            }
        }
    }
}

