/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.aop;

import java.util.Arrays;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.dependency.DependableServiceImporter;
import org.springframework.osgi.service.dependency.MandatoryDependencyEvent;
import org.springframework.osgi.service.dependency.MandatoryDependencyListener;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.internal.aop.ServiceReferenceDelegate;
import org.springframework.osgi.service.importer.internal.support.DefaultRetryCallback;
import org.springframework.osgi.service.importer.internal.support.RetryTemplate;
import org.springframework.osgi.service.importer.internal.support.ServiceWrapper;
import org.springframework.osgi.service.importer.internal.util.OsgiServiceBindingUtils;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ServiceDynamicInterceptor
extends ServiceInvoker
implements InitializingBean,
DisposableBean {
    private static final int hashCode = ServiceDynamicInterceptor.class.hashCode() * 13;
    private final BundleContext bundleContext;
    private final Filter filter;
    private final ClassLoader classLoader;
    private final ServiceReferenceDelegate referenceDelegate;
    private final ServiceListener listener;
    private boolean serviceRequiredAtStartup = true;
    private boolean isDuringDestruction = false;
    private boolean destroyed = false;
    private final Object lock = new Object();
    private ServiceWrapper wrapper;
    private RetryTemplate retryTemplate;
    private List mandatoryListeners;
    private DependableServiceImporter serviceImporter;
    private OsgiServiceLifecycleListener[] listeners = new OsgiServiceLifecycleListener[0];
    private Object proxy;

    public ServiceDynamicInterceptor(BundleContext context, Filter filter, ClassLoader classLoader) {
        this.bundleContext = context;
        this.filter = filter;
        this.classLoader = classLoader;
        this.referenceDelegate = new ServiceReferenceDelegate();
        this.listener = new Listener();
    }

    public Object getTarget() {
        Object target = this.lookupService();
        if (target == null) {
            throw new ServiceUnavailableException(this.filter);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed && !this.isDuringDestruction) {
                throw new IllegalStateException("the service proxy has been destroyed!");
            }
        }
        return this.retryTemplate.execute(new DefaultRetryCallback(){

            public Object doWithRetry() {
                return ServiceDynamicInterceptor.this.wrapper != null ? ServiceDynamicInterceptor.this.wrapper.getService() : null;
            }
        }, this.lock);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.proxy);
        boolean debug = this.log.isDebugEnabled();
        if (this.retryTemplate == null) {
            this.retryTemplate = new RetryTemplate();
        }
        if (debug) {
            this.log.debug((Object)("adding osgi mandatoryListeners for services matching [" + this.filter + "]"));
        }
        OsgiListenerUtils.addSingleServiceListener(this.bundleContext, this.listener, this.filter);
        if (this.serviceRequiredAtStartup) {
            if (debug) {
                this.log.debug((Object)("1..x cardinality - looking for service [" + this.filter + "] at startup..."));
            }
            Object target = this.getTarget();
            if (debug) {
                this.log.debug((Object)("service retrieved " + target));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        OsgiListenerUtils.removeServiceListener(this.bundleContext, this.listener);
        Object object = this.lock;
        synchronized (object) {
            ServiceReference ref;
            this.destroyed = true;
            this.isDuringDestruction = true;
            if (this.wrapper != null && (ref = this.wrapper.getReference()) != null) {
                this.listener.serviceChanged(new ServiceEvent(4, ref));
            }
            this.isDuringDestruction = false;
        }
    }

    public ServiceReference getServiceReference() {
        return this.referenceDelegate;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public OsgiServiceLifecycleListener[] getListeners() {
        return this.listeners;
    }

    public void setListeners(OsgiServiceLifecycleListener[] listeners) {
        this.listeners = listeners;
    }

    public void setDependencyListeners(List listeners) {
        this.mandatoryListeners = listeners;
    }

    public void setServiceImporter(DependableServiceImporter importer) {
        this.serviceImporter = importer;
    }

    public void setRequiredAtStartup(boolean requiredAtStartup) {
        this.serviceRequiredAtStartup = requiredAtStartup;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceDynamicInterceptor) {
            ServiceDynamicInterceptor oth = (ServiceDynamicInterceptor)other;
            return this.serviceRequiredAtStartup == oth.serviceRequiredAtStartup && ObjectUtils.nullSafeEquals((Object)this.wrapper, (Object)oth.wrapper) && ObjectUtils.nullSafeEquals((Object)this.filter, (Object)oth.filter) && ObjectUtils.nullSafeEquals((Object)this.retryTemplate, (Object)oth.retryTemplate) && ObjectUtils.nullSafeEquals((Object)this.serviceImporter, (Object)oth.serviceImporter) && Arrays.equals(this.listeners, oth.listeners);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }

    private class Listener
    implements ServiceListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serviceChanged(ServiceEvent event) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ServiceDynamicInterceptor.this.classLoader);
                ServiceReference ref = event.getServiceReference();
                long serviceId = (Long)ref.getProperty("service.id");
                Integer rank = (Integer)ref.getProperty("service.ranking");
                int ranking = rank == null ? 0 : rank;
                boolean debug = ServiceDynamicInterceptor.this.log.isDebugEnabled();
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        if (!this.updateWrapperIfNecessary(ref, serviceId, ranking)) return;
                        OsgiServiceBindingUtils.callListenersBind(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.proxy, ref, ServiceDynamicInterceptor.this.listeners);
                        if (ServiceDynamicInterceptor.this.mandatoryListeners == null) return;
                        for (int i = 0; i < ServiceDynamicInterceptor.this.mandatoryListeners.size(); ++i) {
                            if (debug) {
                                ServiceDynamicInterceptor.this.log.debug((Object)"calling satisfied on dependency mandatoryListeners");
                            }
                            ((MandatoryDependencyListener)ServiceDynamicInterceptor.this.mandatoryListeners.get(i)).mandatoryDependencySatisfied(new MandatoryDependencyEvent(ServiceDynamicInterceptor.this.serviceImporter));
                        }
                        return;
                    }
                    case 4: {
                        boolean serviceRemoved = false;
                        ServiceWrapper oldWrapper = ServiceDynamicInterceptor.this.wrapper;
                        Object object = ServiceDynamicInterceptor.this.lock;
                        synchronized (object) {
                            if (ServiceDynamicInterceptor.this.wrapper != null && serviceId == ServiceDynamicInterceptor.this.wrapper.getServiceId()) {
                                serviceRemoved = true;
                                ServiceDynamicInterceptor.this.wrapper = null;
                            }
                        }
                        ServiceReference newReference = null;
                        boolean isDestroyed = false;
                        Object object2 = ServiceDynamicInterceptor.this.lock;
                        synchronized (object2) {
                            isDestroyed = ServiceDynamicInterceptor.this.destroyed;
                        }
                        if (!isDestroyed && (newReference = OsgiServiceReferenceUtils.getServiceReference(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.filter == null ? null : ServiceDynamicInterceptor.this.filter.toString())) != null) {
                            this.serviceChanged(new ServiceEvent(2, newReference));
                        }
                        if (newReference != null || !serviceRemoved) return;
                        object2 = ServiceDynamicInterceptor.this.lock;
                        synchronized (object2) {
                            ServiceDynamicInterceptor.this.wrapper = oldWrapper;
                        }
                        if (ServiceDynamicInterceptor.this.mandatoryListeners != null) {
                            for (int i = 0; i < ServiceDynamicInterceptor.this.mandatoryListeners.size(); ++i) {
                                if (debug) {
                                    ServiceDynamicInterceptor.this.log.debug((Object)"calling unsatisfied on dependency mandatoryListeners");
                                }
                                ((MandatoryDependencyListener)ServiceDynamicInterceptor.this.mandatoryListeners.get(i)).mandatoryDependencyUnsatisfied(new MandatoryDependencyEvent(ServiceDynamicInterceptor.this.serviceImporter));
                            }
                        }
                        OsgiServiceBindingUtils.callListenersUnbind(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.proxy, ref, ServiceDynamicInterceptor.this.listeners);
                        Object i = ServiceDynamicInterceptor.this.lock;
                        synchronized (i) {
                            ServiceDynamicInterceptor.this.wrapper = null;
                        }
                        if (!debug) return;
                        String message = "service reference [" + ref + "] was unregistered";
                        message = serviceRemoved ? message + " and was unbound from the service proxy" : message + " but did not affect the service proxy";
                        ServiceDynamicInterceptor.this.log.debug((Object)message);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported event type");
                    }
                }
            }
            catch (Throwable e) {
                ServiceDynamicInterceptor.this.log.fatal((Object)"Exception during service event handling", e);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateWrapperIfNecessary(ServiceReference ref, long serviceId, int serviceRanking) {
            boolean updated = false;
            try {
                Object object = ServiceDynamicInterceptor.this.lock;
                synchronized (object) {
                    if (ServiceDynamicInterceptor.this.wrapper != null && ServiceDynamicInterceptor.this.wrapper.isServiceAlive()) {
                        if (serviceRanking > ServiceDynamicInterceptor.this.wrapper.getServiceRanking()) {
                            updated = true;
                            this.updateReferenceHolders(ref);
                        }
                        if (serviceRanking == ServiceDynamicInterceptor.this.wrapper.getServiceRanking() && serviceId < ServiceDynamicInterceptor.this.wrapper.getServiceId()) {
                            updated = true;
                            this.updateReferenceHolders(ref);
                        }
                    } else {
                        updated = true;
                        this.updateReferenceHolders(ref);
                    }
                    ServiceDynamicInterceptor.this.lock.notifyAll();
                    boolean bl = updated;
                    return bl;
                }
            }
            finally {
                if (ServiceDynamicInterceptor.this.log.isDebugEnabled()) {
                    String message = "service reference [" + ref + "]";
                    message = updated ? message + " bound to proxy" : message + " not bound to proxy";
                    ServiceDynamicInterceptor.this.log.debug((Object)message);
                }
            }
        }

        private void updateReferenceHolders(ServiceReference ref) {
            ServiceDynamicInterceptor.this.wrapper = new ServiceWrapper(ref, ServiceDynamicInterceptor.this.bundleContext);
            ServiceDynamicInterceptor.this.referenceDelegate.swapDelegates(ref);
        }
    }
}

