/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.springframework.osgi.service.importer.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.internal.collection.DynamicCollection;
import org.springframework.osgi.service.importer.internal.collection.DynamicList;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceCollection;

public class OsgiServiceList
extends OsgiServiceCollection
implements List,
RandomAccess {
    protected volatile Object headDeadProxy;
    protected List storage;

    public OsgiServiceList(Filter filter, BundleContext context, ClassLoader classLoader, ServiceProxyCreator proxyCreator) {
        super(filter, context, classLoader, proxyCreator);
    }

    protected DynamicCollection createInternalDynamicStorage() {
        this.storage = new DynamicList();
        return (DynamicList)this.storage;
    }

    public Object get(int index) {
        this.mandatoryServiceCheck();
        return this.storage.get(index);
    }

    protected void checkDeadProxies(Object proxy, int proxyCollectionPos) {
        if (proxyCollectionPos == 0) {
            this.headDeadProxy = proxy;
        }
        super.checkDeadProxies(proxy, proxyCollectionPos);
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new OsgiServiceListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    protected class OsgiServiceListIterator
    implements ListIterator {
        private final ListIterator iter;

        public OsgiServiceListIterator(int index) {
            this.iter = OsgiServiceList.this.storage.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            DynamicCollection dynamicCollection = OsgiServiceList.this.serviceProxies;
            synchronized (dynamicCollection) {
                OsgiServiceList.this.mandatoryServiceCheck();
                Object proxy = this.iter.next();
                return proxy == null ? OsgiServiceList.this.tailDeadProxy : proxy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            DynamicCollection dynamicCollection = OsgiServiceList.this.serviceProxies;
            synchronized (dynamicCollection) {
                OsgiServiceList.this.mandatoryServiceCheck();
                Object proxy = this.iter.previous();
                return proxy == null ? OsgiServiceList.this.headDeadProxy : proxy;
            }
        }

        public boolean hasNext() {
            OsgiServiceList.this.mandatoryServiceCheck();
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            OsgiServiceList.this.mandatoryServiceCheck();
            return this.iter.hasPrevious();
        }

        public int nextIndex() {
            OsgiServiceList.this.mandatoryServiceCheck();
            return this.iter.nextIndex();
        }

        public int previousIndex() {
            OsgiServiceList.this.mandatoryServiceCheck();
            return this.iter.previousIndex();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

