/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

public class ServiceReferenceComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 7552328574956669890L;
    private static final int hashCode = ServiceReferenceComparator.class.hashCode() * 13;

    public int compare(Object o1, Object o2) {
        ServiceReference ref2;
        ServiceReference ref1;
        if (o1 instanceof ServiceReference && o2 instanceof ServiceReference) {
            ref1 = (ServiceReference)o1;
            ref2 = (ServiceReference)o2;
        } else {
            ImportedOsgiServiceProxy obj1 = (ImportedOsgiServiceProxy)o1;
            ImportedOsgiServiceProxy obj2 = (ImportedOsgiServiceProxy)o2;
            ref1 = obj1.getServiceReference();
            ref2 = obj2.getServiceReference();
        }
        return this.compare(ref1, ref2);
    }

    private int compare(ServiceReference ref1, ServiceReference ref2) {
        int rank2;
        long id2;
        long id1 = OsgiServiceReferenceUtils.getServiceId(ref1);
        if (id1 == (id2 = OsgiServiceReferenceUtils.getServiceId(ref2))) {
            return 0;
        }
        int rank1 = OsgiServiceReferenceUtils.getServiceRanking(ref1);
        return rank1 < (rank2 = OsgiServiceReferenceUtils.getServiceRanking(ref2)) ? -1 : (rank1 == rank2 ? (id1 < id2 ? 1 : -1) : 1);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ServiceReferenceComparator;
    }

    public int hashCode() {
        return hashCode;
    }
}

