/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.service.importer.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.internal.collection.CollectionProxy;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceCollection;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceList;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceSet;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceSortedList;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceSortedSet;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.StaticServiceProxyCreator;
import org.springframework.util.Assert;

public class OsgiServiceCollectionProxyFactoryBean
extends AbstractOsgiServiceImportFactoryBean {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceCollectionProxyFactoryBean.class);
    private Collection proxy;
    private CollectionProxy exposedProxy;
    private DisposableBean disposable;
    private ServiceProxyCreator proxyCreator;
    private Comparator comparator;
    private CollectionType collectionType = CollectionType.LIST;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.proxyCreator = new StaticServiceProxyCreator(this.getInterfaces(), this.getBeanClassLoader(), this.getBundleContext(), this.getContextClassLoader());
    }

    public Class getObjectType() {
        return this.proxy != null ? this.proxy.getClass() : this.collectionType.getCollectionClass();
    }

    public boolean isSatisfied() {
        return this.exposedProxy == null ? true : this.exposedProxy.isSatisfied();
    }

    Object createProxy() {
        Collection delegate;
        OsgiServiceCollection collection;
        if (log.isDebugEnabled()) {
            log.debug((Object)"creating a multi-value/collection proxy");
        }
        BundleContext bundleContext = this.getBundleContext();
        ClassLoader classLoader = this.getBeanClassLoader();
        Filter filter = this.getUnifiedFilter();
        if (CollectionType.LIST.equals((Object)this.collectionType)) {
            collection = this.comparator == null ? new OsgiServiceList(filter, bundleContext, classLoader, this.proxyCreator) : new OsgiServiceSortedList(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableList((List)((Object)collection));
        } else if (CollectionType.SET.equals((Object)this.collectionType)) {
            collection = this.comparator == null ? new OsgiServiceSet(filter, bundleContext, classLoader, this.proxyCreator) : new OsgiServiceSortedSet(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableSet((Set)((Object)collection));
        } else if (CollectionType.SORTED_LIST.equals((Object)this.collectionType)) {
            collection = new OsgiServiceSortedList(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableList((List)((Object)collection));
        } else if (CollectionType.SORTED_SET.equals((Object)this.collectionType)) {
            collection = new OsgiServiceSortedSet(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableSortedSet((SortedSet)((Object)collection));
        } else {
            throw new IllegalArgumentException("unknown collection type:" + (Object)((Object)this.collectionType));
        }
        collection.setRequiredAtStartup(this.isMandatory());
        collection.setListeners(this.getListeners());
        collection.afterPropertiesSet();
        this.proxy = delegate;
        this.exposedProxy = collection;
        this.disposable = collection;
        return delegate;
    }

    DisposableBean getDisposable() {
        return this.disposable;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setCollectionType(CollectionType collectionType) {
        Assert.notNull((Object)((Object)collectionType));
        this.collectionType = collectionType;
    }

    public void setCardinality(Cardinality cardinality) {
        Assert.notNull((Object)((Object)cardinality));
        Assert.isTrue((boolean)cardinality.isMultiple(), (String)"only multiple cardinality ('X..N') accepted");
        super.setCardinality(cardinality);
    }
}

