/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.osgi.service.importer.internal.aop.ServiceStaticInterceptor;
import org.springframework.osgi.service.importer.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.ObjectUtils;

class StaticServiceProxyCreator
extends AbstractServiceProxyCreator {
    private static final Log log = LogFactory.getLog((Class)StaticServiceProxyCreator.class);

    StaticServiceProxyCreator(Class[] classes, ClassLoader classLoader, BundleContext bundleContext, ImportContextClassLoader iccl) {
        super(classes, classLoader, bundleContext, iccl);
    }

    Advice createDispatcherInterceptor(ServiceReference reference) {
        return new ServiceStaticInterceptor(this.bundleContext, reference);
    }

    Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
        Bundle bundle = reference.getBundle();
        if (bundle == null) {
            return null;
        }
        return new ServiceTCCLInterceptor(BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle, ProxyFactory.class.getClassLoader()));
    }

    Class[] discoverProxyClasses(ServiceReference ref) {
        String[] classNames = OsgiServiceReferenceUtils.getServiceObjectClasses(ref);
        Class[] classes = ClassUtils.loadClasses(classNames, this.classLoader);
        classes = ClassUtils.excludeClassesWithModifier(classes, 16);
        classes = ClassUtils.removeParents(classes);
        return classes;
    }

    Class[] getInterfaces(ServiceReference reference) {
        Object[] clazzes = this.discoverProxyClasses(reference);
        if (log.isTraceEnabled()) {
            log.trace((Object)("generating 'greedy' service proxy using classes " + ObjectUtils.nullSafeToString((Object[])clazzes) + " over " + ObjectUtils.nullSafeToString((Object[])this.classes)));
        }
        return clazzes;
    }
}

