/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.springframework.osgi.util.LogUtils;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class DebugUtils {
    private static final Log log = LogUtils.createLogger(DebugUtils.class);

    public static void debugClassLoadingThrowable(Throwable loadingThrowable, Bundle bundle, Class[] classes) {
        String className = null;
        if (loadingThrowable instanceof NoClassDefFoundError) {
            className = loadingThrowable.getMessage().replace('/', '.');
        } else if (loadingThrowable instanceof ClassNotFoundException) {
            className = loadingThrowable.getMessage().replace('/', '.');
        }
        if (className != null) {
            DebugUtils.debugClassLoading(bundle, className, null);
            if (!ObjectUtils.isEmpty((Object[])classes) && log.isDebugEnabled()) {
                StringBuffer message = new StringBuffer();
                for (int i = 0; i < classes.length; ++i) {
                    ClassLoader cl = classes[i].getClassLoader();
                    String cansee = "cannot";
                    if (ClassUtils.isPresent((String)className, (ClassLoader)cl)) {
                        cansee = "can";
                    }
                    message.append(classes[i] + " is loaded by " + cl + " which " + cansee + " see " + className);
                }
                log.debug((Object)message);
            }
        }
    }

    public static void debugClassLoading(Bundle bundle, String className, String rootClassName) {
        boolean trace = log.isTraceEnabled();
        if (!trace) {
            return;
        }
        Dictionary dict = bundle.getHeaders();
        String bname = dict.get("Bundle-Name") + "(" + dict.get("Bundle-SymbolicName") + ")";
        if (trace) {
            log.trace((Object)("Could not find class [" + className + "] required by [" + bname + "] scanning available bundles"));
        }
        BundleContext context = OsgiBundleUtils.getBundleContext(bundle);
        String packageName = className.substring(0, className.lastIndexOf(46));
        if (className.indexOf(46) < 0) {
            if (trace) {
                log.trace((Object)"Class is not in a package, its unlikely that this will work");
            }
            return;
        }
        Version iversion = DebugUtils.hasImport(bundle, packageName);
        if (iversion != null && context != null) {
            if (trace) {
                log.trace((Object)("Class is correctly imported as version [" + iversion + "], checking providing bundles"));
            }
            Bundle[] bundles = context.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Version exported;
                if (bundles[i].getBundleId() == bundle.getBundleId() || (exported = DebugUtils.checkBundleForClass(bundles[i], className, iversion)) == null || !exported.equals((Object)iversion) || rootClassName == null) continue;
                for (int j = 0; j < bundles.length; ++j) {
                    Version rootimport;
                    Version rootexport = DebugUtils.hasExport(bundles[j], rootClassName.substring(0, rootClassName.lastIndexOf(46)));
                    if (rootexport == null || (rootimport = DebugUtils.hasImport(bundles[j], packageName)) != null && rootimport.equals((Object)iversion) || !trace) continue;
                    log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundles[j]) + "] exports [" + rootClassName + "] as version [" + rootexport + "] but does not import dependent package [" + packageName + "] at version [" + iversion + "]"));
                }
            }
        }
        if (DebugUtils.hasExport(bundle, packageName) != null) {
            if (trace) {
                log.trace((Object)"Class is exported, checking this bundle");
            }
            DebugUtils.checkBundleForClass(bundle, className, iversion);
        }
    }

    private static Version checkBundleForClass(Bundle bundle, String name, Version iversion) {
        String packageName = name.substring(0, name.lastIndexOf(46));
        Version hasExport = DebugUtils.hasExport(bundle, packageName);
        if (hasExport != null && !hasExport.equals((Object)iversion)) {
            log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] exports [" + packageName + "] as version [" + hasExport + "] but version [" + iversion + "] was required"));
            return hasExport;
        }
        String cname = name.substring(packageName.length() + 1) + ".class";
        Enumeration e = bundle.findEntries("/" + packageName.replace('.', '/'), cname, false);
        if (e == null) {
            Enumeration pe;
            if (hasExport != null) {
                URL url = DebugUtils.checkBundleJarsForClass(bundle, name);
                if (url != null) {
                    log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] contains [" + cname + "] in embedded jar [" + url.toString() + "] but exports the package"));
                } else {
                    log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] does not contain [" + cname + "] but exports the package"));
                }
            }
            String root = "/";
            String fileName = packageName;
            if (packageName.lastIndexOf(".") >= 0) {
                root = root + packageName.substring(0, packageName.lastIndexOf(".")).replace('.', '/');
                fileName = packageName.substring(packageName.lastIndexOf(".") + 1).replace('.', '/');
            }
            if ((pe = bundle.findEntries(root, fileName, false)) != null) {
                if (hasExport != null) {
                    log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] contains package [" + packageName + "] and exports it"));
                } else {
                    log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] contains package [" + packageName + "] but does not export it"));
                }
            }
        } else if (hasExport != null) {
            log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] contains resource [" + cname + "] and it is correctly exported as version [" + hasExport + "]"));
            Class c = null;
            try {
                c = bundle.loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
            log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] loadClass [" + cname + "] returns [" + c + "]"));
        } else {
            log.trace((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] contains resource [" + cname + "] but its package is not exported"));
        }
        return hasExport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL checkBundleJarsForClass(Bundle bundle, String name) {
        String cname = name.replace('.', '/') + ".class";
        Enumeration e = bundle.findEntries("/", "*.jar", true);
        while (e != null && e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            JarInputStream jin = null;
            try {
                jin = new JarInputStream(url.openStream());
                JarEntry ze = jin.getNextJarEntry();
                while (ze != null) {
                    if (ze.getName().equals(cname)) {
                        jin.close();
                        URL uRL = url;
                        return uRL;
                    }
                    ze = jin.getNextJarEntry();
                }
            }
            catch (IOException e1) {
                log.trace((Object)("Skipped " + url.toString() + ": " + e1.getMessage()));
            }
            finally {
                if (jin == null) continue;
                try {
                    jin.close();
                }
                catch (Exception ex) {}
            }
        }
        return null;
    }

    private static Version hasImport(Bundle bundle, String packageName) {
        Dictionary dict = bundle.getHeaders();
        String imports = (String)dict.get("Import-Package");
        Version v = DebugUtils.getVersion(imports, packageName);
        if (v != null) {
            return v;
        }
        String dynimports = (String)dict.get("DynamicImport-Package");
        if (dynimports != null) {
            StringTokenizer strok = new StringTokenizer(dynimports, ",");
            while (strok.hasMoreTokens()) {
                StringTokenizer parts = new StringTokenizer(strok.nextToken(), ";");
                String pkg = parts.nextToken().trim();
                if ((!pkg.endsWith(".*") || !packageName.startsWith(pkg.substring(0, pkg.length() - 2))) && !pkg.equals("*")) continue;
                Version version = Version.emptyVersion;
                while (parts.hasMoreTokens()) {
                    String modifier = parts.nextToken().trim();
                    if (!modifier.startsWith("version")) continue;
                    version = Version.parseVersion((String)modifier.substring(modifier.indexOf("=") + 1).trim());
                }
                return version;
            }
        }
        return null;
    }

    private static Version hasExport(Bundle bundle, String packageName) {
        Dictionary dict = bundle.getHeaders();
        return DebugUtils.getVersion((String)dict.get("Export-Package"), packageName);
    }

    private static Version getVersion(String stmt, String packageName) {
        if (stmt != null) {
            StringTokenizer strok = new StringTokenizer(stmt, ",");
            while (strok.hasMoreTokens()) {
                StringTokenizer parts = new StringTokenizer(strok.nextToken(), ";");
                String pkg = parts.nextToken().trim();
                if (!pkg.equals(packageName)) continue;
                Version version = Version.emptyVersion;
                while (parts.hasMoreTokens()) {
                    String modifier = parts.nextToken().trim();
                    if (!modifier.startsWith("version")) continue;
                    String vstr = modifier.substring(modifier.indexOf("=") + 1).trim();
                    if (vstr.startsWith("\"")) {
                        vstr = vstr.substring(1);
                    }
                    if (vstr.endsWith("\"")) {
                        vstr = vstr.substring(0, vstr.length() - 1);
                    }
                    version = Version.parseVersion((String)vstr);
                }
                return version;
            }
        }
        return null;
    }
}

