/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public final class RemoteCallMessage
extends RemoteOSGiMessage {
    private String serviceID;
    private String methodSignature;
    private Object[] arguments;

    public RemoteCallMessage() {
        super((short)5);
    }

    RemoteCallMessage(ObjectInputStream input) throws IOException, ClassNotFoundException {
        super((short)5);
        this.serviceID = input.readUTF();
        this.methodSignature = input.readUTF();
        short argLength = input.readShort();
        this.arguments = new Object[argLength];
        short i = 0;
        while (i < argLength) {
            this.arguments[i] = input.readObject();
            i = (short)(i + 1);
        }
    }

    public void writeBody(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.serviceID);
        out.writeUTF(this.methodSignature);
        out.writeShort(this.arguments.length);
        int i = 0;
        while (i < this.arguments.length) {
            out.writeObject(this.arguments[i]);
            i = (short)(i + 1);
        }
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    public Object[] getArgs() {
        return this.arguments;
    }

    public void setArgs(Object[] arguments) {
        this.arguments = arguments;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[REMOTE_CALL] - XID: ");
        buffer.append(this.xid);
        buffer.append(", serviceID: ");
        buffer.append(this.serviceID);
        buffer.append(", methodName: ");
        buffer.append(this.methodSignature);
        buffer.append(", params: ");
        buffer.append(this.arguments == null ? "" : Arrays.asList(this.arguments).toString());
        return buffer.toString();
    }
}

