/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import ch.ethz.iks.r_osgi.types.BoxedPrimitive;
import ch.ethz.iks.util.SmartConstants;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class SmartObjectOutputStream
extends ObjectOutputStream {
    private final ObjectOutputStream out;
    static /* synthetic */ Class class$0;

    public SmartObjectOutputStream(OutputStream out) throws IOException {
        this.out = new ObjectOutputStream(out);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void writeObjectOverride(Object o) throws IOException {
        Class<?> clazz;
        if (o == null) {
            this.out.writeByte(0);
            return;
        }
        Object obj = o instanceof BoxedPrimitive ? ((BoxedPrimitive)o).getBoxed() : o;
        String clazzName = obj.getClass().getName();
        if (SmartConstants.positiveList.contains(clazzName)) {
            this.out.writeByte(1);
            String id = (String)SmartConstants.classToId.get(clazzName);
            this.out.writeUTF(id != null ? id : clazzName);
            this.out.writeUTF(obj.toString());
            return;
        }
        if (obj instanceof Serializable) {
            this.out.writeByte(2);
            this.out.writeObject(obj);
            return;
        }
        this.out.writeByte(3);
        Class<?> clazz2 = obj.getClass();
        if (SmartConstants.blackList.contains(clazz2.getName())) {
            throw new NotSerializableException("Class " + clazz2.getName() + " is not serializable");
        }
        this.out.writeUTF(clazz2.getName());
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Method[] methods = clazz2.getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    int mod = methods[j].getModifiers();
                    if (Modifier.isNative(mod)) {
                        throw new NotSerializableException("Class " + clazz2.getName() + " contains native methods and is therefore not serializable.");
                    }
                    ++j;
                }
                try {
                    Field[] fields = clazz2.getDeclaredFields();
                    int fieldCount = fields.length;
                    this.out.writeInt(fieldCount);
                    int i = 0;
                    while (i < fieldCount) {
                        int mod = fields[i].getModifiers();
                        if (!Modifier.isStatic(mod)) {
                            if (!Modifier.isPublic(mod)) {
                                ((AccessibleObject)fields[i]).setAccessible(true);
                            }
                            this.out.writeUTF(fields[i].getName());
                            this.writeObjectOverride(fields[i].get(obj));
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new NotSerializableException("Exception while serializing " + obj.toString() + ":\n" + e.getMessage());
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 != clazz);
        this.out.writeInt(-1);
    }

    public final void write(int val) throws IOException {
        this.out.write(val);
    }

    public final void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    public final void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    public final void reset() throws IOException {
        this.out.reset();
    }

    public final void close() throws IOException {
        this.out.close();
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    public final void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    public final void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    public final void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    public final void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    public final void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    public final void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    public final void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    public final void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    public final void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    public final void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

