/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URITemplate {
    public static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    public static final String LIMITED_REGEX_SUFFIX = "(/.*)?";
    public static final String UNLIMITED_REGEX_SUFFIX = "(/)?";
    public static final String FINAL_MATCH_GROUP = "FINAL_MATCH_GROUP";
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{(\\w[-\\w\\.]*)\\}");
    private static final String PATH_VARIABLE_REGEX = "([^/]+?)";
    private static final String PATH_UNLIMITED_VARIABLE_REGEX = "(.*?)";
    private final String template;
    private final List<String> templateVariables;
    private final Pattern templateRegexPattern;
    private final String literals;

    public URITemplate(String theTemplate) {
        this(theTemplate, true);
    }

    public URITemplate(String theTemplate, boolean limited) {
        boolean endsWithSlash;
        this.template = theTemplate;
        StringBuilder literalChars = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        Matcher matcher = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        int i = 0;
        while (matcher.find()) {
            literalChars.append(this.template.substring(i, matcher.start()));
            this.copyURITemplateCharacters(this.template, i, matcher.start(), stringBuilder);
            i = matcher.end();
            if (!limited && i == this.template.length()) {
                stringBuilder.append(PATH_UNLIMITED_VARIABLE_REGEX);
            } else {
                stringBuilder.append(PATH_VARIABLE_REGEX);
            }
            names.add(matcher.group(1));
        }
        literalChars.append(this.template.substring(i, this.template.length()));
        this.copyURITemplateCharacters(this.template, i, this.template.length(), stringBuilder);
        this.literals = literalChars.toString();
        this.templateVariables = Collections.unmodifiableList(names);
        int endPos = stringBuilder.length() - 1;
        boolean bl = endPos >= 0 ? stringBuilder.charAt(endPos) == '/' : (endsWithSlash = false);
        if (endsWithSlash) {
            stringBuilder.deleteCharAt(endPos);
        }
        stringBuilder.append(limited ? LIMITED_REGEX_SUFFIX : UNLIMITED_REGEX_SUFFIX);
        this.templateRegexPattern = Pattern.compile(stringBuilder.toString());
    }

    public String getLiteralChars() {
        return this.literals;
    }

    public String getValue() {
        return this.template;
    }

    public int getNumberOfGroups() {
        return this.templateVariables.size();
    }

    private void copyURITemplateCharacters(String templateValue, int start, int end, StringBuilder b) {
        for (int i = start; i < end; ++i) {
            char c = templateValue.charAt(i);
            if (c == '?') {
                b.append("\\?");
                continue;
            }
            b.append(c);
        }
    }

    public boolean match(String uri, MultivaluedMap<String, String> templateVariableToValue) {
        if (uri == null) {
            return this.templateRegexPattern == null;
        }
        if (this.templateRegexPattern == null) {
            return false;
        }
        Matcher m = this.templateRegexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        int i = 1;
        for (String name : this.templateVariables) {
            String value = m.group(i++);
            templateVariableToValue.add((Object)name, (Object)value);
        }
        String finalGroup = m.group(i);
        templateVariableToValue.putSingle((Object)FINAL_MATCH_GROUP, (Object)(finalGroup == null ? "/" : finalGroup));
        return true;
    }

    public static URITemplate createTemplate(ClassResourceInfo cri, Path path) {
        if (path == null) {
            return new URITemplate("/");
        }
        String pathValue = path.value();
        if (!pathValue.startsWith("/")) {
            pathValue = "/" + pathValue;
        }
        return new URITemplate(pathValue, path.limited());
    }
}

