/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement40;
import org.apache.derby.iapi.jdbc.BrokeredConnection30;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.FailedProperties40;
import org.apache.derby.impl.jdbc.Util;

public class BrokeredConnection40
extends BrokeredConnection30 {
    public BrokeredConnection40(BrokeredConnectionControl control) {
        super(control);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.getRealConnection().createArrayOf(typeName, elements);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.getRealConnection().createBlob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.getRealConnection().createClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.getRealConnection().createNClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getRealConnection().createSQLXML();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.getRealConnection().createStruct(typeName, attributes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.getRealConnection().isValid(timeout);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(name, value);
        }
        catch (SQLClientInfoException se) {
            this.notifyException(se);
            throw se;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(name, value)).getProperties());
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.getRealConnection().getClientInfo(name);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getRealConnection().getClientInfo();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final BrokeredStatement newBrokeredStatement(BrokeredStatementControl statementControl) throws SQLException {
        try {
            return new BrokeredStatement40(statementControl);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql, Object generatedKeys) throws SQLException {
        try {
            return new BrokeredPreparedStatement40(statementControl, sql, generatedKeys);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql) throws SQLException {
        try {
            return new BrokeredCallableStatement40(statementControl, sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw Util.noCurrentConnection();
            }
            return interfaces.isInstance(this);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw Util.noCurrentConnection();
            }
            try {
                return interfaces.cast(this);
            }
            catch (ClassCastException cce) {
                throw Util.generateCsSQLException("XJ128.S", interfaces);
            }
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }
}

