/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public class PropertyUtil {
    public static final String[] servicePropertyList = new String[]{"derby.engineType", "derby.database.noAutoBoot", "derby.storage.tempDirectory", "encryptionProvider", "encryptionAlgorithm", "restoreFrom", "logDevice", "derby.storage.logArchiveMode"};
    public static final int SET_IN_JVM = 0;
    public static final int SET_IN_DATABASE = 1;
    public static final int SET_IN_APPLICATION = 2;
    public static final int NOT_SET = -1;

    static int whereSet(String key, Dictionary set) {
        boolean dbOnly = PropertyUtil.isDBOnly(set);
        if (!dbOnly && Monitor.getMonitor().getJVMProperty(key) != null) {
            return 0;
        }
        if (set != null && set.get(key) != null) {
            return 1;
        }
        if (!dbOnly && PropertyUtil.getSystemProperty(key) != null) {
            return 2;
        }
        return -1;
    }

    public static boolean isDBOnly(Dictionary set) {
        if (set == null) {
            return false;
        }
        String value = (String)set.get("derby.database.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        return dbOnly;
    }

    public static boolean isDBOnly(Properties set) {
        if (set == null) {
            return false;
        }
        String value = set.getProperty("derby.database.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        return dbOnly;
    }

    public static String getSystemProperty(String key) {
        return PropertyUtil.getSystemProperty(key, null);
    }

    public static String getSystemProperty(String key, String defaultValue) {
        Properties applicationProperties;
        ModuleFactory monitor = Monitor.getMonitorLite();
        String value = monitor.getJVMProperty(key);
        if (value == null && (applicationProperties = monitor.getApplicationProperties()) != null) {
            value = applicationProperties.getProperty(key);
        }
        return value == null ? defaultValue : value;
    }

    public static String getPropertyFromSet(Properties set, String key) {
        boolean dbOnly = set != null ? PropertyUtil.isDBOnly(set) : false;
        return PropertyUtil.getPropertyFromSet(dbOnly, set, key);
    }

    public static Serializable getPropertyFromSet(Dictionary set, String key) {
        boolean dbOnly = set != null ? PropertyUtil.isDBOnly(set) : false;
        return PropertyUtil.getPropertyFromSet(dbOnly, set, key);
    }

    public static Serializable getPropertyFromSet(boolean dbOnly, Dictionary set, String key) {
        if (set != null) {
            Object value;
            if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
                return value;
            }
            value = (Serializable)set.get(key);
            if (value != null) {
                return value;
            }
            if (dbOnly) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(key);
    }

    public static String getPropertyFromSet(boolean dbOnly, Properties set, String key) {
        if (set != null) {
            String value;
            if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
                return value;
            }
            value = set.getProperty(key);
            if (value != null) {
                return value;
            }
            if (dbOnly) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(key);
    }

    public static String getDatabaseProperty(PersistentSet set, String key) throws StandardException {
        if (set == null) {
            return null;
        }
        Serializable obj = set.getProperty(key);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String getServiceProperty(PersistentSet set, String key, String defaultValue) throws StandardException {
        String value = PropertyUtil.getDatabaseProperty(set, "derby.database.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
            return value;
        }
        value = PropertyUtil.getDatabaseProperty(set, key);
        if (value != null) {
            return value;
        }
        if (dbOnly) {
            return defaultValue;
        }
        return PropertyUtil.getSystemProperty(key, defaultValue);
    }

    public static String getServiceProperty(PersistentSet set, String key) throws StandardException {
        return PropertyUtil.getServiceProperty(set, key, null);
    }

    public static boolean getSystemBoolean(String key) {
        return PropertyUtil.getSystemBoolean(key, false);
    }

    public static boolean getSystemBoolean(String key, boolean defaultValue) {
        String value = PropertyUtil.getSystemProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value.trim());
    }

    public static boolean getServiceBoolean(PersistentSet set, String key, boolean defValue) throws StandardException {
        String value = PropertyUtil.getServiceProperty(set, key);
        return PropertyUtil.booleanProperty(key, (Serializable)((Object)value), defValue);
    }

    public static int getSystemInt(String key, int min, int max, int defaultValue) {
        return PropertyUtil.handleInt(PropertyUtil.getSystemProperty(key), min, max, defaultValue);
    }

    public static int getServiceInt(PersistentSet set, String key, int min, int max, int defaultValue) throws StandardException {
        return PropertyUtil.handleInt(PropertyUtil.getServiceProperty(set, key), min, max, defaultValue);
    }

    public static int getServiceInt(PersistentSet set, Properties props, String key, int min, int max, int defaultValue) throws StandardException {
        String value = null;
        if (props != null) {
            value = props.getProperty(key);
        }
        if (value == null) {
            value = PropertyUtil.getServiceProperty(set, key);
        }
        return PropertyUtil.handleInt(value, min, max, defaultValue);
    }

    public static int getSystemInt(String key, int defaultValue) {
        return PropertyUtil.getSystemInt(key, 0, Integer.MAX_VALUE, defaultValue);
    }

    public static int handleInt(String value, int min, int max, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue >= min && intValue <= max) {
                return intValue;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean booleanProperty(String p, Serializable v, boolean defaultValue) throws StandardException {
        if (v == null) {
            return defaultValue;
        }
        String vS = ((String)((Object)v)).trim();
        if ("TRUE".equals(StringUtil.SQLToUpperCase(vS))) {
            return true;
        }
        if ("FALSE".equals(StringUtil.SQLToUpperCase(vS))) {
            return false;
        }
        throw StandardException.newException("XCY00.S", (Object)p, (Object)vS);
    }

    public static int intPropertyValue(String p, Serializable v, int minValue, int maxValue, int defaultValue) throws StandardException {
        if (v == null) {
            return defaultValue;
        }
        String vs = ((String)((Object)v)).trim();
        try {
            int result = Integer.parseInt(vs);
            if (result < minValue || result > maxValue) {
                throw StandardException.newException("XCY00.S", (Object)p, (Object)vs);
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("XCY00.S", (Object)p, (Object)vs);
        }
    }

    public static boolean isServiceProperty(String key) {
        for (int i = 0; i < servicePropertyList.length; ++i) {
            if (!key.equals(servicePropertyList[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean existsBuiltinUser(PersistentSet set, String username) throws StandardException {
        if (PropertyUtil.propertiesContainsBuiltinUser(set.getProperties(), username)) {
            return true;
        }
        boolean dbOnly = false;
        dbOnly = Boolean.valueOf(PropertyUtil.getDatabaseProperty(set, "derby.database.propertiesOnly"));
        return !dbOnly && PropertyUtil.systemPropertiesExistsBuiltinUser(username);
    }

    private static boolean systemPropertiesExistsBuiltinUser(String username) {
        ModuleFactory monitor;
        block3: {
            monitor = Monitor.getMonitorLite();
            try {
                Properties JVMProperties = System.getProperties();
                if (PropertyUtil.propertiesContainsBuiltinUser(JVMProperties, username)) {
                    return true;
                }
            }
            catch (SecurityException e) {
                String key = "derby.user." + IdUtil.SQLIdentifier2CanonicalPropertyUsername(username);
                if (monitor.getJVMProperty(key) == null) break block3;
                return true;
            }
        }
        Properties applicationProperties = monitor.getApplicationProperties();
        return PropertyUtil.propertiesContainsBuiltinUser(applicationProperties, username);
    }

    private static boolean propertiesContainsBuiltinUser(Properties props, String username) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String userAsSpecified;
                String p = (String)e.nextElement();
                if (!p.startsWith("derby.user.") || !username.equals(userAsSpecified = StringUtil.normalizeSQLIdentifier(p.substring("derby.user.".length())))) continue;
                return true;
            }
        }
        return false;
    }
}

