/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SqlXmlUtil
implements Formatable {
    private DocumentBuilder dBuilder;
    private Serializer serializer;
    private XPath query;
    private XPathContext xpContext;
    private String queryExpr;
    private String opName;
    private boolean recompileQuery;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory dBF = null;
            try {
                dBF = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable e) {
                throw StandardException.newException("XML00", "JAXP");
            }
            dBF.setValidating(false);
            dBF.setNamespaceAware(true);
            this.dBuilder = dBF.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler());
            this.loadSerializer();
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.newException("XML01", t, (Object)t.getMessage());
        }
        this.query = null;
    }

    public void compileXQExpr(String queryExpr, String opName) throws StandardException {
        try {
            this.query = new XPath(queryExpr, null, (PrefixResolver)new PrefixResolverDefault((Node)this.dBuilder.newDocument()), 0);
            this.queryExpr = queryExpr;
            this.opName = opName;
            this.recompileQuery = false;
        }
        catch (Throwable te) {
            throw StandardException.newException("10000", te, (Object)opName, (Object)te.getMessage());
        }
    }

    protected String serializeToString(String xmlAsText) throws Exception {
        ArrayList aList = new ArrayList();
        try {
            final InputSource is = new InputSource(new StringReader(xmlAsText));
            aList.add(AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, SAXException {
                    return SqlXmlUtil.this.dBuilder.parse(is);
                }
            }));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return this.serializeToString(aList, null);
    }

    protected String serializeToString(ArrayList items, XMLDataValue xmlVal) throws IOException {
        if (items == null || items.size() == 0) {
            return "";
        }
        StringWriter sWriter = new StringWriter();
        SanityManager.ASSERT(this.serializer != null, "Tried to serialize with uninitialized XML serializer.");
        this.serializer.setWriter((Writer)sWriter);
        DOMSerializer dSer = this.serializer.asDOMSerializer();
        int sz = items.size();
        Object obj = null;
        boolean lastItemWasString = false;
        for (int i = 0; i < sz; ++i) {
            obj = items.get(i);
            if (obj instanceof String) {
                if (lastItemWasString) {
                    sWriter.write(" ");
                }
                sWriter.write((String)obj);
                lastItemWasString = true;
                continue;
            }
            if (obj instanceof Attr) {
                if (xmlVal != null) {
                    xmlVal.markAsHavingTopLevelAttr();
                }
                dSer.serialize((Node)obj);
                lastItemWasString = false;
                continue;
            }
            Node n = obj;
            if (n instanceof Text) {
                sWriter.write(n.getNodeValue());
            } else {
                dSer.serialize(n);
            }
            lastItemWasString = false;
        }
        sWriter.flush();
        return sWriter.toString();
    }

    protected ArrayList evalXQExpression(XMLDataValue xmlContext, boolean returnResults, int[] resultXType) throws Exception {
        if (this.recompileQuery) {
            this.compileXQExpr(this.queryExpr, this.opName);
        }
        SanityManager.ASSERT(this.query != null && this.query.getExpression() != null, "Failed to locate compiled XML query expression.");
        if (xmlContext.getXType() != 0) {
            throw StandardException.newException("2200V", returnResults ? "XMLQUERY" : "XMLEXISTS");
        }
        Document docNode = null;
        docNode = this.dBuilder.parse(new InputSource(new StringReader(xmlContext.getString())));
        this.getXPathContext();
        this.xpContext.reset();
        XObject xOb = this.query.execute(this.xpContext, (Node)docNode, null);
        if (!returnResults) {
            if (xOb instanceof XNodeSet && ((XNodeSet)xOb).nodelist().getLength() > 0) {
                return new ArrayList(0);
            }
            if (!(xOb instanceof XNodeSet)) {
                return new ArrayList(0);
            }
            return null;
        }
        NodeList nodeList = null;
        int numItems = 0;
        if (!(xOb instanceof XNodeSet)) {
            numItems = 1;
        } else {
            nodeList = xOb.nodelist();
            numItems = nodeList.getLength();
        }
        ArrayList<Object> itemRefs = new ArrayList<Object>();
        if (nodeList == null) {
            itemRefs.add(xOb.str());
        } else {
            for (int i = 0; i < numItems; ++i) {
                itemRefs.add(nodeList.item(i));
            }
        }
        nodeList = null;
        resultXType[0] = numItems == 1 && itemRefs.get(0) instanceof Document ? 0 : 1;
        return itemRefs;
    }

    private XPathContext getXPathContext() {
        if (this.xpContext == null) {
            this.xpContext = new XPathContext();
        }
        return this.xpContext;
    }

    private void loadSerializer() throws IOException {
        StringWriter sWriter = new StringWriter();
        Properties props = OutputProperties.getDefaultMethodProperties((String)"xml");
        props.setProperty("method", "xml");
        props.setProperty("omit-xml-declaration", "yes");
        props.setProperty("encoding", "UTF-8");
        this.serializer = SerializerFactory.getSerializer((Properties)props);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.query == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.queryExpr);
            out.writeObject(this.opName);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.queryExpr = (String)in.readObject();
            this.opName = (String)in.readObject();
            this.recompileQuery = true;
        }
    }

    public int getTypeFormatId() {
        return 464;
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

