/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.OutputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

public class BlockedByteArrayOutputStream
extends OutputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayOutputStream(BlockedByteArray src, long pos) {
        if (src == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = src;
        this.pos = pos;
    }

    void setPosition(long newPos) {
        this.pos = newPos;
    }

    long getPosition() {
        return this.pos;
    }

    public void write(int b) {
        this.pos += (long)this.src.writeByte(this.pos, (byte)b);
    }

    public void write(byte[] buf, int offset, int len) {
        this.pos += (long)this.src.writeBytes(this.pos, buf, offset, len);
    }

    public void close() {
        this.src = null;
    }
}

