/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class AnyResultSet
extends NoPutResultSetImpl {
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public final NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    public int subqueryNumber;
    public int pointOfAttachment;

    public AnyResultSet(NoPutResultSet s, Activation a, GeneratedMethod emptyRowFun, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.emptyRowFun = emptyRowFun;
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        this.isOpen = true;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "AnyResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow candidateRow = null;
        Object secondRow = null;
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "AnyResultSet not open");
        if (this.isOpen) {
            candidateRow = this.source.getNextRowCore();
            result = candidateRow != null ? candidateRow : (this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls);
        }
        this.setCurrentRow(result);
        ++this.rowsSeen;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of AnyResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }
}

