/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class ReferenceableDataSource
implements Referenceable,
Serializable,
ObjectFactory {
    private static final long serialVersionUID = 1872877359127597176L;
    private static final Class[] STRING_ARG = new Class[]{"".getClass()};
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private String description;
    private String dataSourceName;
    private String databaseName;
    private String password;
    private String user;
    private int loginTimeout;
    private transient PrintWriter printer;

    public ReferenceableDataSource() {
        this.update();
    }

    public final synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDataSourceName(String dsn) {
        this.dataSourceName = dsn;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String desc) {
        this.description = desc;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printer = out;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref = (Reference)obj;
        String classname = ref.getClassName();
        Object ds = Class.forName(classname).newInstance();
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            Object argValue;
            Method m;
            RefAddr attribute = e.nextElement();
            String propertyName = attribute.getType();
            String value = (String)attribute.getContent();
            String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
            try {
                m = ds.getClass().getMethod(methodName, STRING_ARG);
                argValue = value;
            }
            catch (NoSuchMethodException nsme) {
                try {
                    m = ds.getClass().getMethod(methodName, INT_ARG);
                    argValue = Integer.valueOf(value);
                }
                catch (NoSuchMethodException nsme2) {
                    m = ds.getClass().getMethod(methodName, BOOLEAN_ARG);
                    argValue = Boolean.valueOf(value);
                }
            }
            m.invoke(ds, argValue);
        }
        return ds;
    }

    public final Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "org.apache.derby.jdbc.ReferenceableDataSource", null);
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnType;
            String methodName;
            Method m = methods[i];
            if (m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers()) || (methodName = m.getName()).length() < 5 || !methodName.startsWith("get") || !Integer.TYPE.equals(returnType = m.getReturnType()) && !STRING_ARG[0].equals(returnType) && !Boolean.TYPE.equals(returnType)) continue;
            String propertyName = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(methodName.substring(4));
            try {
                Object ov = m.invoke((Object)this, null);
                if (ov == null) continue;
                ref.add(new StringRefAddr(propertyName, ov.toString()));
                continue;
            }
            catch (IllegalAccessException iae) {
                continue;
            }
            catch (InvocationTargetException ite) {
                // empty catch block
            }
        }
        return ref;
    }

    void update() {
    }

    Connection getConnection(String username, String password, boolean requestPassword) throws SQLException {
        return null;
    }
}

