/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.endpoints;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceUnit;
import org.w3c.dom.Document;

public abstract class AbstractEndpoint
implements Endpoint {
    protected QName service;
    protected String endpoint;
    protected QName interfaceName;
    protected Document description;
    protected Definition definition;
    protected ServiceUnit serviceUnit;
    protected Log logger;
    private String key;

    public AbstractEndpoint() {
    }

    public AbstractEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        this.serviceUnit = serviceUnit;
        this.logger = serviceUnit.getComponent().getLogger();
        this.service = service;
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.key = null;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
        this.key = null;
    }

    public abstract MessageExchange.Role getRole();

    public Document getDescription() {
        return this.description;
    }

    public void setDescription(Document description) {
        this.description = description;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public ServiceUnit getServiceUnit() {
        return this.serviceUnit;
    }

    public void setServiceUnit(ServiceUnit serviceUnit) {
        this.serviceUnit = serviceUnit;
        this.logger = serviceUnit.getComponent().getLogger();
    }

    public boolean isExchangeOkay(MessageExchange exchange) {
        return true;
    }

    public void prepareExchange(MessageExchange exchange) throws MessagingException {
        this.getServiceUnit().getComponent().prepareExchange(exchange, this);
    }

    public abstract void activate() throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void deactivate() throws Exception;

    public abstract void process(MessageExchange var1) throws Exception;

    public String toString() {
        return "Endpoint[service: " + this.service + ", " + "endpoint: " + this.endpoint + ", " + "role: " + (this.getRole() == MessageExchange.Role.PROVIDER ? "provider" : "consumer") + "]";
    }

    public void validate() throws DeploymentException {
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public String getKey() {
        if (this.key == null) {
            if (this.service == null) {
                throw new IllegalArgumentException("Endpoint: " + this + " has no service name defined");
            }
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Endpoint: " + this + " has no endpoint name defined");
            }
            this.key = EndpointSupport.getKey(this.service, this.endpoint);
        }
        return this.key;
    }
}

