/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.nmr.interceptors;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.servicemix.cxf.binding.nmr.NMRMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMROperationInInterceptor
extends AbstractPhaseInterceptor<NMRMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(NMROperationInInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public NMROperationInInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(NMRMessage message) throws Fault {
        Exchange ex = message.getExchange();
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (boi == null && message.getNmrExchange().getOperation() != null) {
            BindingInfo service = ep.getEndpointInfo().getBinding();
            boi = this.getBindingOperationInfo(service, message.getNmrExchange().getOperation());
            if (boi == null) {
                throw new Fault(new Message("UNKNOWN_OPERATION", BUNDLE, new Object[]{message.getNmrExchange().getOperation().toString()}));
            }
            ex.put(BindingOperationInfo.class, (Object)boi);
            ex.put(OperationInfo.class, (Object)boi.getOperationInfo());
            ex.setOneWay(boi.getOperationInfo().isOneWay());
            message.put(MessageInfo.class, boi.getInput().getMessageInfo());
        }
    }

    protected BindingOperationInfo getBindingOperationInfo(BindingInfo service, QName operation) {
        return service.getOperation(operation);
    }
}

