/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.nmr.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.cxf.binding.nmr.NMRBindingInfo;
import org.apache.servicemix.cxf.binding.nmr.NMRConstants;

public class NMRWrapperInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(NMRWrapperInInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public NMRWrapperInInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isGET(message)) {
            LOG.info("JbiMessageInInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xsr);
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        BindingInfo binding = ep.getEndpointInfo().getBinding();
        if (!(binding instanceof NMRBindingInfo)) {
            throw new IllegalStateException(new org.apache.cxf.common.i18n.Message("NEED_JBIBINDING", BUNDLE, new Object[0]).toString());
        }
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_ELEMENT", BUNDLE, new Object[0]));
        }
        Exchange ex = message.getExchange();
        QName startQName = reader.getName();
        if (startQName.getLocalPart().equals("NMRFault")) {
            message.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(message);
                return;
            }
        }
        if (!startQName.equals(NMRConstants.JBI_WRAPPER_MESSAGE)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_JBI_MESSAGE_ELEMENT", BUNDLE, new Object[0]));
        }
        try {
            BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
            DataReader dr = this.getDataReader(message);
            ArrayList<Object> parameters = new ArrayList<Object>();
            reader.next();
            BindingMessageInfo messageInfo = !this.isRequestor(message) ? bop.getInput() : bop.getOutput();
            message.put(MessageInfo.class, (Object)messageInfo.getMessageInfo());
            for (MessagePartInfo part : messageInfo.getMessageParts()) {
                if (!StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader)) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("NOT_ENOUGH_PARTS", BUNDLE, new Object[0]));
                }
                startQName = reader.getName();
                if (!startQName.equals(NMRConstants.JBI_WRAPPER_PART)) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("NO_JBI_PART_ELEMENT", BUNDLE, new Object[0]));
                }
                if (part.isElement()) {
                    reader.next();
                    if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                        throw new Fault(new org.apache.cxf.common.i18n.Message("EXPECTED_ELEMENT_IN_PART", BUNDLE, new Object[0]));
                    }
                }
                parameters.add(dr.read(part, (Object)reader));
                if (!part.isElement()) continue;
                reader.next();
            }
            int ev = reader.getEventType();
            while (ev != 2 && ev != 1 && ev != 8) {
                ev = reader.next();
            }
            message.setContent(List.class, parameters);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }
}

