/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.endpoints.DefaultHttpConsumerMarshaler;
import org.apache.servicemix.http.endpoints.HttpConsumerMarshaler;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.mortbay.util.ajax.WaitingContinuation;
import org.w3c.dom.Node;

public class HttpConsumerEndpoint
extends ConsumerEndpoint
implements HttpProcessor,
HttpEndpointType {
    public static final String MAIN_WSDL = "main.wsdl";
    private String authMethod;
    private SslParameters ssl;
    private String locationURI;
    private HttpConsumerMarshaler marshaler;
    private long timeout;
    private URI defaultMep = JbiConstants.IN_OUT;
    private Map<String, Object> resources = new HashMap<String, Object>();
    private Map<String, Continuation> locks = new ConcurrentHashMap<String, Continuation>();
    private Map<String, MessageExchange> exchanges = new ConcurrentHashMap<String, MessageExchange>();
    private Object httpContext;
    private boolean started = false;

    public HttpConsumerEndpoint() {
    }

    public HttpConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HttpConsumerMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpConsumerMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public SslParameters getSsl() {
        return this.ssl;
    }

    public void setSsl(SslParameters ssl) {
        this.ssl = ssl;
    }

    public URI getDefaultMep() {
        return this.defaultMep;
    }

    public void setDefaultMep(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public void activate() throws Exception {
        super.activate();
        this.loadStaticResources();
        this.httpContext = this.getServerManager().createContext(this.locationURI, this);
    }

    public void deactivate() throws Exception {
        this.getServerManager().remove(this.httpContext);
        this.httpContext = null;
        super.deactivate();
    }

    public void start() throws Exception {
        super.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        Continuation cont = this.locks.get(exchange.getExchangeId());
        if (cont == null) {
            throw new Exception("HTTP request has timed out for exchange: " + exchange.getExchangeId());
        }
        Continuation continuation = cont;
        synchronized (continuation) {
            if (this.locks.remove(exchange.getExchangeId()) == null) {
                throw new Exception("HTTP request has timed out for exchange: " + exchange.getExchangeId());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resuming continuation for exchange: " + exchange.getExchangeId()));
            }
            this.exchanges.put(exchange.getExchangeId(), exchange);
            cont.resume();
            if (!cont.isResumed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not resume continuation for exchange: " + exchange.getExchangeId()));
                }
                this.exchanges.remove(exchange.getExchangeId());
                throw new Exception("HTTP request has timed out for exchange: " + exchange.getExchangeId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block27: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Receiving HTTP request: " + request));
            }
            MessageExchange exchange = null;
            try {
                Continuation continuation;
                if (this.handleStaticResource(request, response)) {
                    return;
                }
                Continuation cont = this.createContinuation(request);
                if (!cont.isPending()) {
                    if (!this.started) {
                        response.sendError(503, "Endpoint is stopped");
                        return;
                    }
                    exchange = this.createExchange(request);
                    this.exchanges.put(exchange.getExchangeId(), exchange);
                    request.setAttribute(MessageExchange.class.getName(), (Object)exchange.getExchangeId());
                    this.locks.put(exchange.getExchangeId(), cont);
                    continuation = cont;
                    synchronized (continuation) {
                        long to;
                        this.send(exchange);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Suspending continuation for exchange: " + exchange.getExchangeId()));
                        }
                        if ((to = this.timeout) == 0L) {
                            to = ((HttpComponent)this.getServiceUnit().getComponent()).getConfiguration().getConsumerProcessorSuspendTime();
                        }
                        boolean result = cont.suspend(to);
                        exchange = this.exchanges.remove(exchange.getExchangeId());
                        request.removeAttribute(MessageExchange.class.getName());
                        if (!result) {
                            this.locks.remove(exchange.getExchangeId());
                            throw new Exception("Exchange timed out");
                        }
                    }
                }
                continuation = cont;
                synchronized (continuation) {
                    String id = (String)request.getAttribute(MessageExchange.class.getName());
                    this.locks.remove(id);
                    exchange = this.exchanges.remove(id);
                    request.removeAttribute(MessageExchange.class.getName());
                    if (exchange == null) {
                        throw new IllegalStateException("Exchange not found");
                    }
                    if (!cont.isResumed()) {
                        throw new Exception("Exchange timed out: " + exchange.getExchangeId());
                    }
                }
                if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    Exception e = exchange.getError();
                    if (e == null) {
                        e = new Exception("Unkown error (exchange aborted ?)");
                    }
                    throw e;
                }
                if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                    try {
                        Fault fault = exchange.getFault();
                        if (fault != null) {
                            this.sendFault(exchange, fault, request, response);
                        } else {
                            NormalizedMessage outMsg = exchange.getMessage("out");
                            if (outMsg != null) {
                                this.sendOut(exchange, outMsg, request, response);
                            }
                        }
                        this.done(exchange);
                        break block27;
                    }
                    catch (Exception e) {
                        this.fail(exchange, e);
                        throw e;
                    }
                }
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    this.sendAccepted(exchange, request, response);
                }
            }
            catch (RetryRequest e) {
                throw e;
            }
            catch (Exception e) {
                this.sendError(exchange, e, request, response);
            }
        }
    }

    private Continuation createContinuation(HttpServletRequest request) {
        Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, null);
        if (continuation instanceof WaitingContinuation) {
            return continuation;
        }
        return new ContinuationWrapper(continuation);
    }

    protected void loadStaticResources() throws Exception {
    }

    protected boolean handleStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object res;
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        String query = request.getQueryString();
        if (query != null && query.trim().equalsIgnoreCase("wsdl") && this.getResource(MAIN_WSDL) != null) {
            String uri = request.getRequestURI();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + MAIN_WSDL;
            response.sendRedirect(uri);
            return true;
        }
        String path = request.getPathInfo();
        if (path.lastIndexOf(47) >= 0) {
            path = path.substring(path.lastIndexOf(47) + 1);
        }
        if ((res = this.getResource(path)) == null) {
            return false;
        }
        if (res instanceof Node) {
            response.setStatus(200);
            response.setContentType("text/xml");
            try {
                new SourceTransformer().toResult((Source)new DOMSource((Node)res), (Result)new StreamResult((OutputStream)response.getOutputStream()));
            }
            catch (TransformerException e) {
                throw new ServletException("Error while sending xml resource", (Throwable)e);
            }
        } else {
            if (res != null) {
                throw new ServletException("Unable to serialize resource");
            }
            return false;
        }
        return true;
    }

    protected Object getResource(String path) {
        return this.resources.get(path);
    }

    protected void addResource(String path, Object resource) {
        this.resources.put(path, resource);
    }

    protected ContextManager getServerManager() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return comp.getServer();
    }

    public MessageExchange createExchange(HttpServletRequest request) throws Exception {
        MessageExchange me = this.marshaler.createExchange(request, this.getContext());
        if (me.getEndpoint() == null) {
            this.configureExchangeTarget(me);
        }
        if (request.getUserPrincipal() instanceof JaasJettyPrincipal) {
            Subject subject = ((JaasJettyPrincipal)request.getUserPrincipal()).getSubject();
            me.getMessage("in").setSecuritySubject(subject);
        }
        return me;
    }

    public void sendAccepted(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendAccepted(exchange, request, response);
    }

    public void sendError(MessageExchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendError(exchange, error, request, response);
    }

    public void sendFault(MessageExchange exchange, Fault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendFault(exchange, fault, request, response);
    }

    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendOut(exchange, outMsg, request, response);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.marshaler == null) {
            this.marshaler = new DefaultHttpConsumerMarshaler();
        }
        if (this.marshaler instanceof DefaultHttpConsumerMarshaler) {
            ((DefaultHttpConsumerMarshaler)this.marshaler).setDefaultMep(this.getDefaultMep());
        }
    }

    private static final class ContinuationWrapper
    implements Continuation {
        private final Continuation continuation;

        private ContinuationWrapper(Continuation continuation) {
            this.continuation = continuation;
        }

        public Object getObject() {
            return this.continuation.getObject();
        }

        public boolean isNew() {
            return this.continuation.isNew();
        }

        public boolean isPending() {
            return this.continuation.isPending();
        }

        public boolean isResumed() {
            return this.continuation.isResumed();
        }

        public void reset() {
            this.continuation.reset();
        }

        public void resume() {
            this.continuation.resume();
        }

        public void setObject(Object o) {
            this.continuation.setObject(o);
        }

        public boolean suspend(long timeout) {
            return this.continuation.suspend(timeout);
        }
    }
}

