/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.UserRealm;

public class JaasUserRealm
implements UserRealm {
    private static final Log LOG = LogFactory.getLog(JaasUserRealm.class);
    private String name = this.getClass().getName();
    private String domain = "servicemix-domain";
    private AuthenticationService authenticationService;
    private final Map<String, JaasJettyPrincipal> userMap = new ConcurrentHashMap<String, JaasJettyPrincipal>();

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Principal authenticate(String username, Object credentials, Request request) {
        try {
            if (username != null && !username.equals("")) {
                JaasJettyPrincipal userPrincipal = this.userMap.get(username);
                if (userPrincipal != null) {
                    this.userMap.remove(username);
                }
                Subject subject = new Subject();
                this.authenticationService.authenticate(subject, this.domain, username, credentials);
                userPrincipal = new JaasJettyPrincipal(username);
                userPrincipal.setSubject(subject);
                this.userMap.put(username, userPrincipal);
                return userPrincipal;
            }
            LOG.debug((Object)"Login Failed - null userID");
            return null;
        }
        catch (GeneralSecurityException e) {
            LOG.debug((Object)"Login Failed", (Throwable)e);
            return null;
        }
    }

    public void disassociate(Principal user) {
    }

    public Principal getPrincipal(String username) {
        return this.userMap.get(username);
    }

    public boolean isUserInRole(Principal user, String role) {
        return false;
    }

    public void logout(Principal user) {
        JaasJettyPrincipal principal = (JaasJettyPrincipal)user;
        this.userMap.remove(principal.getName());
    }

    public Principal popRole(Principal user) {
        return null;
    }

    public Principal pushRole(Principal user, String role) {
        return null;
    }

    public boolean reauthenticate(Principal user) {
        return this.userMap.get(user.getName()) != null;
    }
}

