/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.jbi.JBIException;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.artifacts.AbstractLifecycleJbiArtifact;
import org.apache.servicemix.jbi.deployer.artifacts.AssemblyReferencesListener;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceUnitImpl;
import org.apache.servicemix.jbi.deployer.descriptor.Connection;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.events.LifeCycleEvent;
import org.apache.servicemix.nmr.api.Wire;
import org.apache.servicemix.nmr.core.util.MapToDictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyImpl
extends AbstractLifecycleJbiArtifact
implements ServiceAssembly {
    private final Bundle bundle;
    private final ServiceAssemblyDesc serviceAssemblyDesc;
    private final List<ServiceUnitImpl> serviceUnits;
    private final AssemblyReferencesListener listener;
    private Map<Wire, ServiceRegistration> wires = new HashMap<Wire, ServiceRegistration>();
    private int shutdownTimeout;

    public ServiceAssemblyImpl(Bundle bundle, ServiceAssemblyDesc serviceAssemblyDesc, List<ServiceUnitImpl> serviceUnits, Preferences prefs, AssemblyReferencesListener listener, boolean autoStart) {
        this.bundle = bundle;
        this.serviceAssemblyDesc = serviceAssemblyDesc;
        this.serviceUnits = serviceUnits;
        this.prefs = prefs;
        this.listener = listener;
        this.runningState = this.loadState(autoStart ? AbstractLifecycleJbiArtifact.State.Started : AbstractLifecycleJbiArtifact.State.Shutdown);
        for (ServiceUnitImpl su : serviceUnits) {
            su.setServiceAssemblyImpl(this);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String getName() {
        return this.serviceAssemblyDesc.getIdentification().getName();
    }

    @Override
    public String getDescription() {
        return this.serviceAssemblyDesc.getIdentification().getDescription();
    }

    @Override
    public String getDescriptor() {
        URL url = this.bundle.getResource("META-INF/jbi.xml");
        return DescriptorFactory.getDescriptorAsText(url);
    }

    @Override
    public ServiceUnit[] getServiceUnits() {
        return this.serviceUnits.toArray(new ServiceUnit[this.serviceUnits.size()]);
    }

    public List<ServiceUnitImpl> getServiceUnitsList() {
        return this.serviceUnits;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() throws JBIException {
        this.checkComponentsStarted();
        this.listener.setAssembly(this);
        try {
            if (this.runningState == AbstractLifecycleJbiArtifact.State.Started) {
                this.transition(Action.Init, AbstractLifecycleJbiArtifact.State.Stopped);
                this.transition(Action.Start, AbstractLifecycleJbiArtifact.State.Started);
            } else if (this.runningState == AbstractLifecycleJbiArtifact.State.Stopped) {
                this.transition(Action.Init, AbstractLifecycleJbiArtifact.State.Stopped);
            } else if (this.runningState == AbstractLifecycleJbiArtifact.State.Shutdown) {
                this.transition(Action.Init, AbstractLifecycleJbiArtifact.State.Stopped);
                this.transition(Action.Shutdown, AbstractLifecycleJbiArtifact.State.Shutdown);
                this.state = AbstractLifecycleJbiArtifact.State.Shutdown;
            }
        }
        finally {
            this.listener.setAssembly(null);
        }
    }

    public void start() throws JBIException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(boolean persist) throws JBIException {
        this.checkComponentsStarted();
        this.listener.setAssembly(this);
        try {
            if (this.state == AbstractLifecycleJbiArtifact.State.Started) {
                return;
            }
            if (this.state == AbstractLifecycleJbiArtifact.State.Shutdown) {
                this.transition(Action.Init, AbstractLifecycleJbiArtifact.State.Stopped);
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Starting);
            this.startConnections();
            this.transition(Action.Start, AbstractLifecycleJbiArtifact.State.Started);
            if (persist) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Started);
        }
        finally {
            this.listener.setAssembly(null);
        }
    }

    public void stop() throws JBIException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean persist) throws JBIException {
        this.listener.setAssembly(this);
        try {
            if (this.state == AbstractLifecycleJbiArtifact.State.Stopped) {
                return;
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopping);
            if (this.state == AbstractLifecycleJbiArtifact.State.Shutdown) {
                this.transition(Action.Init, AbstractLifecycleJbiArtifact.State.Stopped);
            }
            if (this.state == AbstractLifecycleJbiArtifact.State.Started) {
                this.transition(Action.Stop, AbstractLifecycleJbiArtifact.State.Stopped);
            }
            this.stopConnections();
            if (persist) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopped);
        }
        finally {
            this.listener.setAssembly(null);
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(true, false);
    }

    @Override
    public void forceShutDown() throws JBIException {
        this.shutDown(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutDown(boolean persist, boolean force) throws JBIException {
        this.listener.setAssembly(this);
        Semaphore semaphore = force && this.shutdownTimeout > 0 ? this.startShutdownMonitorThread() : null;
        try {
            if (this.state == AbstractLifecycleJbiArtifact.State.Shutdown) {
                return;
            }
            if (this.state == AbstractLifecycleJbiArtifact.State.Started) {
                this.transition(Action.Stop, AbstractLifecycleJbiArtifact.State.Stopped);
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.ShuttingDown);
            if (!force) {
                while (true) {
                    try {
                        this.listener.waitFor(this);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            this.transition(Action.Shutdown, AbstractLifecycleJbiArtifact.State.Shutdown);
            if (persist) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.ShutDown);
        }
        finally {
            this.listener.setAssembly(null);
            this.listener.forget(this);
            if (semaphore != null) {
                semaphore.release();
            }
        }
    }

    protected void checkComponentsStarted() throws JBIException {
        HashSet<String> names = new HashSet<String>();
        for (ServiceUnitImpl su : this.serviceUnits) {
            if (su.getComponent() == null) {
                throw new JBIException("SU has not been correctly deployed: " + su.getName());
            }
            if ("Started".equals(su.getComponent().getCurrentState())) continue;
            names.add(su.getComponentName());
        }
        if (!names.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(name);
            }
            throw new JBIException("Components are not started: " + sb.toString());
        }
    }

    protected void transition(Action action, AbstractLifecycleJbiArtifact.State to) throws JBIException {
        this.LOGGER.info((Object)("Changing SA state to " + (Object)((Object)to)));
        AbstractLifecycleJbiArtifact.State from = this.state;
        ArrayList<ServiceUnitImpl> success = new ArrayList<ServiceUnitImpl>();
        for (ServiceUnitImpl su : this.serviceUnits) {
            try {
                this.changeState(su, action);
                success.add(su);
            }
            catch (JBIException e) {
                if (from != AbstractLifecycleJbiArtifact.State.Unknown) {
                    for (ServiceUnitImpl su2 : success) {
                        try {
                            this.changeState(su2, action.reverse());
                        }
                        catch (JBIException e2) {}
                    }
                }
                throw e;
            }
        }
        this.state = to;
    }

    protected void changeState(ServiceUnitImpl su, Action action) throws JBIException {
        switch (action) {
            case Init: {
                su.init();
                break;
            }
            case Start: {
                su.start();
                break;
            }
            case Stop: {
                su.stop();
                break;
            }
            case Shutdown: {
                su.shutdown();
            }
        }
    }

    private void startConnections() {
        if (this.serviceAssemblyDesc.getConnections() != null && this.serviceAssemblyDesc.getConnections().getConnections() != null) {
            for (Connection connection : this.serviceAssemblyDesc.getConnections().getConnections()) {
                Wire wire = connection.getWire();
                this.wires.put(wire, this.registerWire(wire));
            }
        }
    }

    private void stopConnections() {
        for (Wire wire : this.wires.keySet()) {
            this.wires.get(wire).unregister();
        }
    }

    protected ServiceRegistration registerWire(Wire wire) {
        return this.bundle.getBundleContext().registerService(Wire.class.getName(), (Object)wire, (Dictionary)new MapToDictionary(wire.getFrom()));
    }

    private Semaphore startShutdownMonitorThread() {
        final Semaphore semaphore = new Semaphore(0);
        Thread thread = new Thread(this.getName() + " - Shutdown Monitor Thread"){

            public void run() {
                try {
                    ServiceAssemblyImpl.this.LOGGER.debug((Object)("Waiting for " + ServiceAssemblyImpl.this.shutdownTimeout + " milliseconds to a clean shutdown of SA " + ServiceAssemblyImpl.this.getName()));
                    if (!semaphore.tryAcquire(ServiceAssemblyImpl.this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                        ServiceAssemblyImpl.this.LOGGER.warn((Object)("Unable to do a clean shutdown of SA " + ServiceAssemblyImpl.this.getName() + ", canceling all sync exchanges"));
                        ServiceAssemblyImpl.this.listener.cancelPendingSyncExchanges(ServiceAssemblyImpl.this);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return semaphore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        Init,
        Start,
        Stop,
        Shutdown;


        public Action reverse() {
            switch (this) {
                case Init: {
                    return Shutdown;
                }
                case Start: {
                    return Stop;
                }
                case Stop: {
                    return Start;
                }
                case Shutdown: {
                    return Init;
                }
            }
            throw new IllegalStateException();
        }
    }
}

