/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.task;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.servicemix.jbi.deployer.AdminCommandsService;
import org.apache.servicemix.jbi.deployer.impl.DefaultNamingStrategy;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class JbiTask
extends Task {
    private String serverProtocol = "rmi";
    private String host = "localhost";
    private String containerName = "ServiceMix";
    private String jmxDomainName = "org.apache.servicemix";
    private int port = 1099;
    private String jndiPath = "/jmxrmi";
    private String username;
    private String password;
    private boolean failOnError = true;
    private JMXConnector jmxConnector;

    public JMXServiceURL getServiceURL() throws MalformedURLException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + this.jndiPath);
        return url;
    }

    public JMXConnector getJMXConnector(JMXServiceURL url) throws IOException {
        String[] credentials = new String[]{this.getUsername(), this.getPassword()};
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        environment.put("jmx.remote.credentials", credentials);
        return JMXConnectorFactory.connect(url, environment);
    }

    public void connect() throws IOException {
        this.jmxConnector = this.getJMXConnector(this.getServiceURL());
    }

    public void close() {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException e) {
                this.log("Caught an error closing the jmxConnector" + e.getMessage(), 1);
            }
        }
    }

    public AdminCommandsService getAdminCommandsService() throws IOException {
        ObjectName objectName = DefaultNamingStrategy.getSystemObjectName(this.jmxDomainName, this.containerName, AdminCommandsService.class);
        return MBeanServerInvocationHandler.newProxyInstance(this.jmxConnector.getMBeanServerConnection(), objectName, AdminCommandsService.class, true);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public String getJndiPath() {
        return this.jndiPath;
    }

    public void setJndiPath(String jndiPath) {
        this.jndiPath = jndiPath;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() throws BuildException {
        AdminCommandsService acs;
        try {
            this.log("Retrieving remote admin interface", 4);
            this.connect();
            acs = this.getAdminCommandsService();
        }
        catch (Throwable e) {
            this.log("Error accessing ServiceMix administration: " + e.getMessage(), 1);
            if (this.isFailOnError()) {
                throw new BuildException("Error accessing ServiceMix administration", e);
            }
            return;
        }
        try {
            this.log("Executing command", 4);
            this.doExecute(acs);
        }
        catch (Throwable e) {
            this.log("Error executing command: " + e.getMessage(), 1);
            if (this.isFailOnError()) {
                throw new BuildException("Error accessing ServiceMix administration", e);
            }
            return;
        }
    }

    protected abstract void doExecute(AdminCommandsService var1) throws Exception;
}

