/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.Environment;
import org.apache.servicemix.jbi.runtime.impl.ComponentRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementContext {
    private static final Log LOGGER = LogFactory.getLog(ComponentRegistryImpl.class);
    private String jmxDomainName;
    private Environment environment;

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("Type", "Component");
        result.put("Name", ManagementContext.sanitizeString(name));
        result.put("SubType", ManagementContext.sanitizeString(type));
        return this.createObjectName(result);
    }

    public ObjectName createObjectName(Map<String, String> props) {
        return ManagementContext.createObjectName(this.getJmxDomainName(), props);
    }

    public static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }

    public static ObjectName createObjectName(String domain, Map<String, String> props) {
        StringBuffer sb = new StringBuffer();
        sb.append(domain).append(':');
        int i = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append((Object)entry.getKey()).append("=").append((Object)entry.getValue());
        }
        ObjectName result = null;
        try {
            result = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            String error = "Could not create ObjectName for " + props;
            LOGGER.error((Object)error, (Throwable)e);
            throw new RuntimeException(error);
        }
        return result;
    }

    public void registerMBean(ObjectName objectName, Object object, Class interfaceMBean, String description) {
    }

    public void unregisterMBean(Object object) {
    }
}

