/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.LocalFileStorageEditorInput;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.MacroInvocation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenDeclarationUtils {
    private OpenDeclarationUtils() {
    }

    public static IRegion createRegion(EObject eObj) {
        int b;
        Variable eVariable;
        Region res = null;
        if (eObj instanceof ModuleElement) {
            int b2;
            ModuleElement eModuleElement = (ModuleElement)eObj;
            if (eModuleElement.eResource() != null && (b2 = eModuleElement.getStartPosition()) > -1) {
                int e = eModuleElement.getEndPosition();
                res = new Region(b2, e - b2);
            }
        } else if (eObj instanceof Variable && (eVariable = (Variable)eObj).eResource() != null && (b = eVariable.getStartPosition()) > -1) {
            res = new Region(b, eVariable.getEndPosition() - b);
        }
        return res;
    }

    public static EObject findDeclarationFromAST(ASTNode astNode) {
        Object res = null;
        if (astNode instanceof TemplateInvocation) {
            Template eTemplate;
            res = eTemplate = ((TemplateInvocation)astNode).getDefinition();
        } else if (astNode instanceof QueryInvocation) {
            Query eQuery = ((QueryInvocation)astNode).getDefinition();
            res = eQuery;
        } else if (astNode instanceof MacroInvocation) {
            Macro eMacro = ((MacroInvocation)astNode).getDefinition();
            res = eMacro;
        } else if (astNode instanceof VariableExp) {
            Variable eVariable = (Variable)((VariableExp)astNode).getReferredVariable();
            res = eVariable;
        } else if (astNode instanceof OperationCallExp) {
            EOperation eOperation = (EOperation)((OperationCallExp)astNode).getReferredOperation();
            res = eOperation;
        } else if (astNode instanceof PropertyCallExp) {
            EStructuralFeature eProperty = (EStructuralFeature)((PropertyCallExp)astNode).getReferredProperty();
            res = eProperty;
        } else if (astNode instanceof Variable) {
            EClassifier eClassifier = (EClassifier)((Variable)astNode).getType();
            res = eClassifier;
        } else if (astNode instanceof TypeExp) {
            EClassifier eClassifier = (EClassifier)((TypeExp)astNode).getReferredType();
            res = eClassifier;
        } else if (astNode instanceof IteratorExp) {
            res = ((IteratorExp)astNode).getBody().getStartPosition() == -1 && ((IteratorExp)astNode).getBody().getEndPosition() == -1 ? OpenDeclarationUtils.findDeclarationFromAST((ASTNode)((IteratorExp)astNode).getBody()) : astNode;
        } else if (astNode instanceof Template) {
            Template template;
            res = template = (Template)astNode;
        } else if (astNode instanceof Query) {
            Query query = (Query)astNode;
            res = query;
        }
        return res;
    }

    public static EObject findIteratorEOperation(Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> environment, IteratorExp iteratorExp) {
        EPackage stdLibPackage = (EPackage)((EClassifier)environment.getOCLStandardLibrary().getCollection()).eContainer();
        EClassifier sourceType = (EClassifier)iteratorExp.getSource().getType();
        String operationHolderName = sourceType.getName().substring(0, sourceType.getName().indexOf(40)).concat("(T)_Class");
        EClassifier operationHolder = stdLibPackage.getEClassifier(operationHolderName);
        String operationName = iteratorExp.getName();
        EOperation referredOperation = null;
        for (EObject child : new ArrayList(operationHolder.eContents())) {
            if (!(child instanceof EOperation) || !operationName.equals(((EOperation)child).getName())) continue;
            referredOperation = (EOperation)child;
            break;
        }
        return referredOperation;
    }

    public static EObject findDeclarationFromCST(AcceleoEditor editor, ASTNode astNode, CSTNode cstNode) {
        EPackage res;
        block5: {
            String overridesName;
            block7: {
                block6: {
                    block4: {
                        EPackage ePackage;
                        res = null;
                        if (!(cstNode instanceof TypedModel)) break block4;
                        EList ePackages = ((TypedModel)cstNode).getTakesTypesFrom();
                        if (ePackages.size() <= 0) break block5;
                        res = ePackage = (EPackage)ePackages.get(0);
                        break block5;
                    }
                    if (!(cstNode instanceof ModuleImportsValue)) break block6;
                    String importName = ((ModuleImportsValue)cstNode).getName();
                    if (importName == null || editor.getContent().getAST() == null) break block5;
                    Iterator eModules = editor.getContent().getAST().getImports().iterator();
                    while (res == null && eModules.hasNext()) {
                        Module eModule = (Module)eModules.next();
                        if (!importName.equalsIgnoreCase(eModule.getNsURI()) && !importName.equalsIgnoreCase(eModule.getName())) continue;
                        res = eModule;
                    }
                    break block5;
                }
                if (!(cstNode instanceof ModuleExtendsValue)) break block7;
                String extendsName = ((ModuleExtendsValue)cstNode).getName();
                if (extendsName == null || editor.getContent().getAST() == null) break block5;
                Iterator eModules = editor.getContent().getAST().getExtends().iterator();
                while (res == null && eModules.hasNext()) {
                    Module eModule = (Module)eModules.next();
                    if (!extendsName.equalsIgnoreCase(eModule.getNsURI()) && !extendsName.equalsIgnoreCase(eModule.getName())) continue;
                    res = eModule;
                }
                break block5;
            }
            if (cstNode instanceof TemplateOverridesValue && (overridesName = ((TemplateOverridesValue)cstNode).getName()) != null && astNode instanceof Template) {
                Iterator eOverrides = ((Template)astNode).getOverrides().iterator();
                while (res == null && eOverrides.hasNext()) {
                    Template eOverride = (Template)eOverrides.next();
                    if (!overridesName.equalsIgnoreCase(eOverride.getName())) continue;
                    res = eOverride;
                }
            }
        }
        return res;
    }

    public static void showEObject(IWorkbenchPage page, URI fileURI, IRegion region, EObject eObject) {
        URI newFileURI;
        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
        if (fileURI != null && eObject != null && (newFileURI = OpenDeclarationUtils.formatURI(fileURI)) != null && !(eObject instanceof ASTNode) && !(eObject instanceof Module)) {
            String lastSegment;
            IEditorDescriptor editorDescriptor;
            Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(newFileURI);
            if (fileObject instanceof IFile) {
                newFileURI = URI.createPlatformResourceURI((String)((IFile)fileObject).getFullPath().toString(), (boolean)false);
            }
            if ((editorDescriptor = (lastSegment = newFileURI.lastSegment()).endsWith("emtl") || lastSegment.endsWith(".ecore") || lastSegment.endsWith(".xmi") || lastSegment.endsWith(".uml") ? OpenDeclarationUtils.getXMIEditor() : workbench.getEditorRegistry().getDefaultEditor(lastSegment)) != null) {
                try {
                    IEditorPart newEditor = page.openEditor((IEditorInput)new URIEditorInput(newFileURI), editorDescriptor.getId());
                    OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                }
                catch (PartInitException newEditor) {
                    // empty catch block
                }
            }
        }
        if (fileURI != null && (eObject instanceof ASTNode || eObject instanceof Module)) {
            Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(fileURI);
            IFile file = null;
            File absoluteFile = null;
            if (fileObject instanceof IFile) {
                file = (IFile)fileObject;
            } else if (fileObject instanceof File) {
                absoluteFile = (File)fileObject;
            }
            if (file == null && absoluteFile != null) {
                Object input = new URIEditorInput(fileURI);
                IEditorDescriptor editor = OpenDeclarationUtils.getXMIEditor();
                String editorID = editor != null ? editor.getId() : "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
                File[] siblings = absoluteFile.getParentFile().listFiles();
                int i = 0;
                while (i < siblings.length) {
                    if (siblings[i].getName().equals(new Path(absoluteFile.getName()).removeFileExtension().addFileExtension("mtl").lastSegment())) {
                        input = new LocalFileStorageEditorInput((IStorage)new LocalFileStorage(siblings[i]));
                        editorID = "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
                        break;
                    }
                    ++i;
                }
                try {
                    IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editorID);
                    OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                }
                catch (PartInitException partInitException) {}
            } else if (file != null) {
                try {
                    IEditorDescriptor editorDescriptor;
                    IPath filePath = file.getFullPath();
                    if ("emtl".equals(filePath.getFileExtension())) {
                        filePath = new AcceleoProject(file.getProject()).getInputFilePath(filePath);
                        file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    }
                    if ((editorDescriptor = workbench.getEditorRegistry().getDefaultEditor(file.getName())) != null) {
                        IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorDescriptor.getId());
                        OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }

    public static Object getIFileXorIOFile(URI fileURI) {
        IFile tmpFile;
        String absolutePath;
        IFile workspaceFile = null;
        File absoluteFile = null;
        String platformString = fileURI.toPlatformString(true);
        Path platformPath = platformString != null ? new Path(platformString) : null;
        if (platformPath != null && platformPath.segmentCount() > 1) {
            if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)platformPath)) {
                workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformPath);
            } else {
                String pluginName = platformPath.segment(0);
                Bundle bundle = Platform.getBundle((String)pluginName);
                if (bundle != null) {
                    OpenDeclarationUtils.getAbsoluteFile(bundle, platformPath.removeFirstSegments(1).removeFileExtension().addFileExtension("mtl").toString());
                    absoluteFile = OpenDeclarationUtils.getAbsoluteFile(bundle, platformPath.removeFirstSegments(1).toString());
                }
            }
        }
        if ((absolutePath = fileURI.toFileString()) != null) {
            absoluteFile = new File(absolutePath);
        }
        if (workspaceFile == null && fileURI.isFile() && absoluteFile != null && (tmpFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(absolutePath))) != null && tmpFile.exists()) {
            workspaceFile = tmpFile;
        }
        if (absoluteFile != null && !absoluteFile.exists()) {
            absoluteFile = null;
        }
        if (workspaceFile != null) {
            return workspaceFile;
        }
        return absoluteFile;
    }

    private static File getAbsoluteFile(Bundle bundle, String entryPath) {
        File absoluteFile;
        block5: {
            URL entry = bundle.getEntry(entryPath);
            if (entry != null) {
                try {
                    entry = FileLocator.toFileURL((URL)entry);
                    if (entry != null) {
                        absoluteFile = new Path(entry.getPath()).toFile();
                        break block5;
                    }
                    absoluteFile = null;
                }
                catch (IOException e1) {
                    absoluteFile = null;
                }
            } else {
                absoluteFile = null;
            }
        }
        return absoluteFile;
    }

    private static URI findEcore(Bundle bundle, String ecoreName) {
        Enumeration entries = bundle.findEntries("/", ecoreName, true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                if (entry == null) continue;
                IPath path = new Path(bundle.getSymbolicName()).append(entry.getPath());
                return URI.createPlatformPluginURI((String)path.toString(), (boolean)false);
            }
        }
        return null;
    }

    private static URI formatURI(URI fileURI) {
        URI result = null;
        String fileURIString = fileURI.toString();
        String ecorePath = ModelUtils.getRegisteredEcorePackagePath((String)fileURIString);
        if (ecorePath != null) {
            result = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        }
        if (result == null && fileURIString.startsWith("http")) {
            IConfigurationElement member;
            int j;
            IConfigurationElement[] members;
            IExtension extension;
            int i;
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String mURI = member.getAttribute("uri");
                        String genModelPath = member.getAttribute("genModel");
                        String bundleID = member.getNamespaceIdentifier();
                        if (mURI != null && mURI.equals(fileURIString) && Platform.getBundle((String)bundleID) != null && genModelPath != null) {
                            String ecoreName = new Path(genModelPath).removeFileExtension().addFileExtension("ecore").lastSegment();
                            result = OpenDeclarationUtils.findEcore(Platform.getBundle((String)bundleID), ecoreName);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.uri_mapping");
            if (result == null && extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String sourceURI = member.getAttribute("source");
                        String targetURI = member.getAttribute("target");
                        if (sourceURI != null && sourceURI.equals(fileURIString) && targetURI != null) {
                            result = URI.createURI((String)targetURI, (boolean)false);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (result != null) {
            return result;
        }
        return fileURI;
    }

    private static IEditorDescriptor getXMIEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor editorDescriptor = workbench.getEditorRegistry().findEditor("org.eclipse.emf.ecore.presentation.EcoreEditorID");
        if (editorDescriptor == null && (editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.ecore")) == null) {
            editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.xmi");
        }
        return editorDescriptor;
    }

    private static void selectAndReveal(IEditorPart newEditor, IRegion aRegion, EObject eObject) {
        if (newEditor instanceof AcceleoEditor) {
            OpenDeclarationUtils.selectAndReveal((AcceleoEditor)newEditor, aRegion, eObject);
        } else if (newEditor instanceof IEditingDomainProvider && eObject.eResource() != null) {
            IEditingDomainProvider editor = (IEditingDomainProvider)newEditor;
            String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
            if (editor.getEditingDomain() != null && editor.getEditingDomain().getResourceSet() != null && editor.getEditingDomain().getResourceSet().getResources().size() > 0 && eObjectFragmentURI != null) {
                EObject newObject = ((Resource)editor.getEditingDomain().getResourceSet().getResources().get(0)).getEObject(eObjectFragmentURI);
                if (editor instanceof IViewerProvider) {
                    OpenDeclarationUtils.setSelectionToViewer(newObject, ((IViewerProvider)editor).getViewer());
                }
            }
        }
    }

    private static void selectAndReveal(AcceleoEditor acceleoEditor, IRegion aRegion, EObject eObject) {
        IRegion region = aRegion;
        if (region != null && eObject instanceof ModuleElement) {
            int e = acceleoEditor.getContent().getText().indexOf("]", region.getOffset());
            if (e > -1) {
                region = new Region(region.getOffset(), e + "]".length() - region.getOffset());
            }
            acceleoEditor.selectAndReveal(region.getOffset(), region.getLength());
        } else if (region != null) {
            acceleoEditor.selectAndReveal(region.getOffset(), region.getLength());
        } else {
            int defaultEnd;
            int defaultBegin;
            EObject newEObject = null;
            Module eModule = acceleoEditor.getContent().getAST();
            if (eModule != null && eModule.eResource() != null && eObject != null) {
                String eObjectFragmentURI = null;
                if (eObject.eResource() != null) {
                    eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
                } else if (eObject.eIsProxy()) {
                    eObjectFragmentURI = ((InternalEObject)eObject).eProxyURI().fragment();
                }
                try {
                    newEObject = eModule.eResource().getEObject(eObjectFragmentURI);
                }
                catch (IllegalArgumentException e) {
                    newEObject = eObject;
                }
            }
            if (eObject instanceof ASTNode) {
                defaultBegin = ((ASTNode)eObject).getStartPosition();
                defaultEnd = ((ASTNode)eObject).getEndPosition();
            } else {
                defaultBegin = -1;
                defaultEnd = -1;
            }
            if (newEObject instanceof ASTNode) {
                OpenDeclarationUtils.selectAndRevealASTNode(acceleoEditor, (ASTNode)newEObject, defaultBegin, defaultEnd);
            }
        }
    }

    private static void selectAndRevealASTNode(AcceleoEditor acceleoEditor, ASTNode astNode, int defaultBegin, int defaultEnd) {
        int e;
        int b;
        if (astNode != null) {
            b = astNode.getStartPosition();
            e = astNode.getEndPosition();
        } else {
            b = -1;
            e = -1;
        }
        if (b == -1) {
            b = defaultBegin;
        }
        if (e == -1) {
            e = defaultEnd;
        }
        if (b > -1) {
            if (b + "[".length() < acceleoEditor.getContent().getText().length() && acceleoEditor.getContent().getText().substring(b, b + "[".length()).equals("[")) {
                e = acceleoEditor.getContent().getText().indexOf("]", b) + "]".length();
            }
            if (e < b) {
                e = b;
            }
            acceleoEditor.selectAndReveal(b, e - b);
        }
    }

    private static void setSelectionToViewer(final EObject selectedEObject, final Viewer viewer) {
        if (selectedEObject != null && viewer != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectedEObject), true);
                }
            };
            viewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    public static IRegion findIdentifierRegion(IDocument document, int offset) {
        int startValue = -2;
        int start = -2;
        int end = -1;
        int max = document.getLength();
        try {
            char c;
            int pos = offset;
            while (pos >= 0 && pos < max) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException pos) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            Region region = null;
            region = start == offset && end == offset ? new Region(offset, 0) : (start == offset ? new Region(start, end - start) : new Region(start + 1, end - start - 1));
            return region;
        }
        return null;
    }

    public static EObject findDeclaration(AcceleoEditor editor, boolean withImportsExtends) {
        CSTNode cstNode;
        EObject res = null;
        ISelection selection = editor.getSelectionProvider().getSelection();
        int offset = selection instanceof TextSelection ? ((TextSelection)selection).getOffset() : -1;
        ASTNode astNode = null;
        astNode = withImportsExtends ? editor.getContent().getASTNode(offset, offset) : editor.getContent().getASTNodeWithoutImportsExtends(offset, offset);
        if (astNode != null) {
            res = OpenDeclarationUtils.computeEObject(astNode, offset);
        }
        if (res == null && (cstNode = editor.getContent().getCSTNode(offset, offset)) != null) {
            res = OpenDeclarationUtils.findDeclarationFromCST(editor, astNode, cstNode);
        }
        return res;
    }

    private static EObject computeEObject(ASTNode astNode, int offset) {
        EObject res = null;
        if (astNode instanceof Variable && ((Variable)astNode).getName() != null && offset < ((Variable)astNode).getStartPosition() + ((Variable)astNode).getName().length()) {
            res = astNode;
        } else if (astNode instanceof CollectionLiteralExp) {
            CollectionLiteralExp collectionLiteralExp = (CollectionLiteralExp)astNode;
            EList part = collectionLiteralExp.getPart();
            for (CollectionLiteralPart collectionLiteralPart : part) {
                CollectionItem item;
                OCLExpression expression;
                if (!(collectionLiteralPart instanceof CollectionItem) || (expression = (item = (CollectionItem)collectionLiteralPart).getItem()).getStartPosition() > offset || expression.getEndPosition() < offset) continue;
                res = expression;
            }
        } else {
            res = OpenDeclarationUtils.findDeclarationFromAST(astNode);
        }
        return res;
    }

    public static EObject findResolvedDeclaration(AcceleoEditor editor) {
        CSTNode cstNode;
        Object res = null;
        ISelection selection = editor.getSelectionProvider().getSelection();
        int offset = selection instanceof TextSelection ? ((TextSelection)selection).getOffset() : -1;
        ASTNode astNode = editor.getContent().getResolvedASTNode(offset, offset);
        if (astNode != null) {
            res = astNode instanceof Variable && ((Variable)astNode).getName() != null && offset < ((Variable)astNode).getStartPosition() + ((Variable)astNode).getName().length() ? astNode : OpenDeclarationUtils.findDeclarationFromAST(astNode);
        }
        if (res == null && (cstNode = editor.getContent().getCSTNode(offset, offset)) != null) {
            res = OpenDeclarationUtils.findDeclarationFromCST(editor, astNode, cstNode);
        }
        return res;
    }

    public static List<Match> findOccurrences(AcceleoEditor editor, EObject object) {
        ArrayList<Match> list = new ArrayList<Match>();
        ReferencesSearchQuery searchQuery = new ReferencesSearchQuery(editor, object);
        searchQuery.run((IProgressMonitor)new NullProgressMonitor());
        ReferencesSearchResult result = (ReferencesSearchResult)searchQuery.getSearchResult();
        Object[] array = result.getElements();
        int i = 0;
        while (i < array.length) {
            if (((ReferenceEntry)array[i]).getRegion() != null) {
                list.add(new Match(array[i], ((ReferenceEntry)array[i]).getRegion().getOffset(), ((ReferenceEntry)array[i]).getRegion().getLength()));
            }
            ++i;
        }
        return list;
    }

    public static List<Match> getMatchesFromTheFile(List<Match> matches, IFile file) {
        ArrayList<Match> list = new ArrayList<Match>();
        for (Match match : matches) {
            if (!((ReferenceEntry)match.getElement()).getTemplateFile().equals((Object)file)) continue;
            list.add(match);
        }
        return list;
    }

    public static boolean checkTemplateEqual(Template t1, Template t2) {
        boolean result;
        if (t1 != null && t2 != null) {
            result = t1.getName().equals(t2.getName());
            result = result && t1.getStartPosition() == t2.getStartPosition();
            result = result && t1.getEndPosition() == t2.getEndPosition();
        } else {
            result = false;
        }
        return result;
    }

    public static Template findContainingTemplateOf(EObject object) {
        EObject temp = object;
        while (temp != null && !(temp instanceof Template)) {
            temp = temp.eContainer();
        }
        return (Template)temp;
    }
}

